/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.internal.IteratorSupport;
import com.codahale.metrics.Timer;
import com.nimbusds.infinispan.persistence.common.InfinispanEntry;
import com.nimbusds.infinispan.persistence.dynamodb.RequestFactory;
import com.nimbusds.infinispan.persistence.dynamodb.logging.Loggers;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.PersistenceException;

@ThreadSafe
class ExpiredEntryReaper<K, V> {
    private final MarshalledEntryFactory<K, V> marshalledEntryFactory;
    private final Table table;
    private final RequestFactory<K, V> requestFactory;
    private final int maxNumEntriesToReap;
    private final Timer purgeTimer;

    ExpiredEntryReaper(MarshalledEntryFactory<K, V> marshalledEntryFactory, Table table, RequestFactory<K, V> requestFactory, int maxNumEntriesToReap, Timer purgeTimer) {
        assert (marshalledEntryFactory != null);
        this.marshalledEntryFactory = marshalledEntryFactory;
        assert (table != null);
        this.table = table;
        assert (requestFactory != null);
        this.requestFactory = requestFactory;
        this.maxNumEntriesToReap = maxNumEntriesToReap;
        assert (purgeTimer != null);
        this.purgeTimer = purgeTimer;
    }

    int purge(AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        Timer.Context timerCtx = this.purgeTimer.time();
        try {
            long now = new Date().getTime();
            AtomicInteger deleteCounter = new AtomicInteger(0);
            IteratorSupport it = this.requestFactory.getAllItems(this.table).iterator();
            while (it.hasNext() && (this.maxNumEntriesToReap <= -1 || deleteCounter.get() < this.maxNumEntriesToReap)) {
                boolean deleted;
                Item item = (Item)it.next();
                InfinispanEntry<K, V> infinispanEntry = this.requestFactory.getItemTransformer().toInfinispanEntry(item);
                InternalMetadata metadata = infinispanEntry.getMetadata();
                if (metadata == null || !metadata.isExpired(now) || !(deleted = this.table.deleteItem(this.requestFactory.resolveDeleteItemSpec(infinispanEntry.getKey())).getItem() != null)) continue;
                purgeListener.entryPurged(infinispanEntry.getKey());
                deleteCounter.incrementAndGet();
            }
            Loggers.DYNAMODB_LOG.debug("[DS0128] DynamoDB store: Purged {} expired {} cache entries", (Object)deleteCounter.get(), (Object)this.table.getTableName());
            int n = deleteCounter.get();
            return n;
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0127] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException("Purge exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }

    int purgeExtended(AdvancedCacheExpirationWriter.ExpirationPurgeListener<K, V> purgeListener) {
        Timer.Context timerCtx = this.purgeTimer.time();
        try {
            long now = new Date().getTime();
            AtomicInteger deleteCounter = new AtomicInteger(0);
            IteratorSupport it = this.requestFactory.getAllItems(this.table).iterator();
            while (it.hasNext() && (this.maxNumEntriesToReap <= -1 || deleteCounter.get() < this.maxNumEntriesToReap)) {
                boolean deleted;
                Item item = (Item)it.next();
                InfinispanEntry<K, V> infinispanEntry = this.requestFactory.getItemTransformer().toInfinispanEntry(item);
                InternalMetadata metadata = infinispanEntry.getMetadata();
                if (metadata == null || !metadata.isExpired(now) || !(deleted = this.table.deleteItem(this.requestFactory.resolveDeleteItemSpec(infinispanEntry.getKey())).getItem() != null)) continue;
                MarshalledEntry marshalledEntry = this.marshalledEntryFactory.newMarshalledEntry(infinispanEntry.getKey(), infinispanEntry.getValue(), infinispanEntry.getMetadata());
                purgeListener.marshalledEntryPurged(marshalledEntry);
                deleteCounter.incrementAndGet();
            }
            Loggers.DYNAMODB_LOG.debug("[DS0128] DynamoDB store: Purged {} expired {} cache entries", (Object)deleteCounter.get(), (Object)this.table.getTableName());
            int n = deleteCounter.get();
            return n;
        }
        catch (Exception e) {
            Loggers.DYNAMODB_LOG.error("[DS0151] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException("Purge exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }
}

