/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

class ItemSanitization {
    static Item sanitize(Item item) {
        return Item.fromMap(ItemSanitization.sanitize(item.asMap()));
    }

    static Map<String, Object> sanitize(Map<String, Object> map) {
        LinkedList<String> keysToRemove = new LinkedList<String>();
        for (String key : map.keySet()) {
            boolean toRemove;
            Object value = map.get(key);
            if (value == null) continue;
            boolean bl = toRemove = String.class.isAssignableFrom(value.getClass()) && ((String)value).isEmpty() || byte[].class.isAssignableFrom(value.getClass()) && ((byte[])value).length == 0 || ByteBuffer.class.isAssignableFrom(value.getClass()) && ((ByteBuffer)value).array().length == 0 || Collection.class.isAssignableFrom(value.getClass()) && ((Collection)value).isEmpty();
            if (toRemove) {
                keysToRemove.add(key);
            }
            if (!Map.class.isAssignableFrom(value.getClass())) continue;
            ItemSanitization.sanitize((Map)value);
        }
        keysToRemove.forEach(map::remove);
        return map;
    }

    private ItemSanitization() {
    }
}

