/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.nimbusds.infinispan.persistence.common.InternalMetadataBuilder;
import org.infinispan.metadata.InternalMetadata;

public class MetadataUtils {
    public static Item addMetadata(Item item, InternalMetadata metadata) {
        return MetadataUtils.addMetadata(item, metadata, false);
    }

    public static Item addMetadata(Item item, InternalMetadata metadata, boolean withTTL) {
        if (metadata == null) {
            return item;
        }
        if (metadata.created() > -1L) {
            item.withLong("iat", metadata.created());
        }
        if (metadata.lifespan() > -1L) {
            item.withLong("max", metadata.lifespan());
        }
        if (metadata.maxIdle() > -1L) {
            item.withLong("idl", metadata.maxIdle());
        }
        if (metadata.lastUsed() > -1L) {
            item.withLong("lat", metadata.lastUsed());
        }
        if (withTTL && metadata.created() > -1L && metadata.lifespan() > -1L) {
            item.withLong("ttl", (metadata.created() + metadata.lifespan()) / 1000L);
        }
        return item;
    }

    public static InternalMetadata parseMetadata(Item item) {
        InternalMetadataBuilder b = new InternalMetadataBuilder();
        if (item.hasAttribute("iat")) {
            b.created(item.getLong("iat"));
        }
        if (item.hasAttribute("max")) {
            b.lifespan(item.getLong("max"));
        }
        if (item.hasAttribute("idl")) {
            b.maxIdle(item.getLong("idl"));
        }
        if (item.hasAttribute("lat")) {
            b.lastUsed(item.getLong("lat"));
        }
        return b.build();
    }
}

