/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb.config;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ENDPOINT("endpoint"),
    REGION("region"),
    ITEM_TRANSFORMER("item-transformer"),
    QUERY_EXECUTOR("query-executor"),
    INDEXED_ATTRIBUTES("indexed-attributes"),
    CONSISTENT_READS("consistent-reads"),
    READ_CAPACITY("read-capacity"),
    WRITE_CAPACITY("write-capacity"),
    ENCRYPTION_AT_REST("encryption-at-rest"),
    TABLE_PREFIX("table-prefix"),
    APPLY_RANGE_KEY("apply-range-key"),
    RANGE_KEY_VALUE("range-key-value"),
    ENABLE_STREAM("enable-stream"),
    ENABLE_CONTINUOUS_BACKUPS("enable-continuous-backups"),
    ENABLE_TTL("enable-ttl"),
    PURGE_LIMIT("purge-limit"),
    HTTP_PROXY_HOST("http-proxy-host"),
    HTTP_PROXY_PORT("http-proxy-port"),
    HMAC_SHA256_KEY("hmac-sha256-key");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

