/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb.config;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.codahale.metrics.MetricRegistry;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.infinispan.persistence.dynamodb.DynamoDBStore;
import com.nimbusds.infinispan.persistence.dynamodb.config.DynamoDBStoreConfigurationBuilder;
import com.nimbusds.infinispan.persistence.dynamodb.logging.Loggers;
import java.util.Properties;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.logging.log4j.util.Supplier;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;

@Immutable
@BuiltBy(value=DynamoDBStoreConfigurationBuilder.class)
@ConfigurationFor(value=DynamoDBStore.class)
public class DynamoDBStoreConfiguration
extends AbstractStoreConfiguration
implements LoggableConfiguration {
    static final AttributeDefinition<String> ENDPOINT = AttributeDefinition.builder((String)"endpoint", null, String.class).build();
    static final AttributeDefinition<Regions> REGION = AttributeDefinition.builder((String)"region", null, Regions.class).build();
    static final AttributeDefinition<Class> ITEM_TRANSFORMER = AttributeDefinition.builder((String)"recordTransformer", null, Class.class).build();
    static final AttributeDefinition<Class> QUERY_EXECUTOR = AttributeDefinition.builder((String)"queryExecutor", null, Class.class).build();
    static final AttributeDefinition<Set> INDEXED_ATTRIBUTES = AttributeDefinition.builder((String)"indexedAttributes", null, Set.class).build();
    static final AttributeDefinition<Boolean> CONSISTENT_READS = AttributeDefinition.builder((String)"consistentReads", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Long> READ_CAPACITY = AttributeDefinition.builder((String)"readCapacity", (Object)1L, Long.class).build();
    static final AttributeDefinition<Long> WRITE_CAPACITY = AttributeDefinition.builder((String)"writeCapacity", (Object)1L, Long.class).build();
    static final AttributeDefinition<Boolean> ENCRYPTION_AT_REST = AttributeDefinition.builder((String)"encryptionAtRest", (Object)false, Boolean.class).build();
    static final AttributeDefinition<String> TABLE_PREFIX = AttributeDefinition.builder((String)"tablePrefix", (Object)"", String.class).build();
    static final AttributeDefinition<MetricRegistry> METRIC_REGISTRY = AttributeDefinition.builder((String)"metricRegistry", null, MetricRegistry.class).build();
    static final AttributeDefinition<String> APPLY_RANGE_KEY = AttributeDefinition.builder((String)"applyRangeKey", null, String.class).build();
    static final AttributeDefinition<String> RANGE_KEY_VALUE = AttributeDefinition.builder((String)"rangeKeyValue", null, String.class).build();
    static final AttributeDefinition<Boolean> ENABLE_STREAM = AttributeDefinition.builder((String)"enableStream", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Boolean> ENABLE_CONTINUOUS_BACKUPS = AttributeDefinition.builder((String)"enableContinuousBackups", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Boolean> ENABLE_TTL = AttributeDefinition.builder((String)"enableTTL", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Integer> PURGE_LIMIT = AttributeDefinition.builder((String)"purgeLimit", (Object)-1, Integer.class).build();
    static final AttributeDefinition<String> HTTP_PROXY_HOST = AttributeDefinition.builder((String)"httpProxyHost", null, String.class).build();
    static final AttributeDefinition<Integer> HTTP_PROXY_PORT = AttributeDefinition.builder((String)"httpProxyPort", (Object)-1, Integer.class).build();
    static final AttributeDefinition<String> HMAC_SHA_256_KEY = AttributeDefinition.builder((String)"hmacSHA256Key", null, String.class).build();
    private final Attribute<String> endpoint;
    private final Attribute<Regions> region;
    private final Attribute<Class> itemTransformerClass;
    private final Attribute<Class> queryExecutorClass;
    private final Attribute<Set> indexedAttributes;
    private final Attribute<Boolean> consistentRead;
    private final Attribute<String> tablePrefix;
    private final Attribute<Long> readCapacity;
    private final Attribute<Long> writeCapacity;
    private final Attribute<Boolean> encryptionAtRest;
    private final Attribute<String> applyRangeKey;
    private final Attribute<String> rangeKeyValue;
    private final Attribute<Boolean> enableStream;
    private final Attribute<MetricRegistry> metricRegistry;
    private final Attribute<Boolean> enableContinuousBackups;
    private final Attribute<Boolean> enableTTL;
    private final Attribute<Integer> purgeLimit;
    private final Attribute<String> httpProxyHost;
    private final Attribute<Integer> httpProxyPort;
    private final Attribute<String> hmacSHA256Key;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(DynamoDBStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{ENDPOINT, REGION, ITEM_TRANSFORMER, QUERY_EXECUTOR, INDEXED_ATTRIBUTES, CONSISTENT_READS, READ_CAPACITY, WRITE_CAPACITY, ENCRYPTION_AT_REST, TABLE_PREFIX, APPLY_RANGE_KEY, RANGE_KEY_VALUE, ENABLE_STREAM, METRIC_REGISTRY, ENABLE_CONTINUOUS_BACKUPS, ENABLE_TTL, PURGE_LIMIT, HTTP_PROXY_HOST, HTTP_PROXY_PORT, HMAC_SHA_256_KEY});
    }

    public DynamoDBStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration asyncConfig, SingletonStoreConfiguration singletonStoreConfig) {
        super(attributes, asyncConfig, singletonStoreConfig);
        this.endpoint = attributes.attribute(ENDPOINT);
        assert (this.endpoint != null);
        this.region = attributes.attribute(REGION);
        assert (this.region != null);
        this.itemTransformerClass = attributes.attribute(ITEM_TRANSFORMER);
        assert (this.itemTransformerClass != null);
        this.queryExecutorClass = attributes.attribute(QUERY_EXECUTOR);
        this.indexedAttributes = attributes.attribute(INDEXED_ATTRIBUTES);
        this.consistentRead = attributes.attribute(CONSISTENT_READS);
        this.readCapacity = attributes.attribute(READ_CAPACITY);
        assert (this.readCapacity != null);
        this.writeCapacity = attributes.attribute(WRITE_CAPACITY);
        assert (this.writeCapacity != null);
        this.encryptionAtRest = attributes.attribute(ENCRYPTION_AT_REST);
        this.tablePrefix = attributes.attribute(TABLE_PREFIX);
        assert (this.tablePrefix != null);
        this.applyRangeKey = attributes.attribute(APPLY_RANGE_KEY);
        assert (this.applyRangeKey != null);
        this.rangeKeyValue = attributes.attribute(RANGE_KEY_VALUE);
        assert (this.rangeKeyValue != null);
        this.enableStream = attributes.attribute(ENABLE_STREAM);
        assert (this.enableStream != null);
        this.enableContinuousBackups = attributes.attribute(ENABLE_CONTINUOUS_BACKUPS);
        assert (this.enableContinuousBackups != null);
        this.enableTTL = attributes.attribute(ENABLE_TTL);
        assert (this.enableTTL != null);
        this.purgeLimit = attributes.attribute(PURGE_LIMIT);
        this.httpProxyHost = attributes.attribute(HTTP_PROXY_HOST);
        this.httpProxyPort = attributes.attribute(HTTP_PROXY_PORT);
        this.hmacSHA256Key = attributes.attribute(HMAC_SHA_256_KEY);
        this.metricRegistry = attributes.attribute(METRIC_REGISTRY);
    }

    public String getEndpoint() {
        return (String)this.endpoint.get();
    }

    public Regions getRegion() {
        return (Regions)this.region.get();
    }

    public Class getItemTransformerClass() {
        return (Class)this.itemTransformerClass.get();
    }

    public Class getQueryExecutorClass() {
        return (Class)this.queryExecutorClass.get();
    }

    public Set<String> getIndexedAttributes() {
        return (Set)this.indexedAttributes.get();
    }

    public boolean isConsistentReads() {
        return (Boolean)this.consistentRead.get();
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return new ProvisionedThroughput((Long)this.readCapacity.get(), (Long)this.writeCapacity.get());
    }

    public boolean isTableWithEncryptionAtRest() {
        return (Boolean)this.encryptionAtRest.get();
    }

    public String getTablePrefix() {
        return (String)this.tablePrefix.get();
    }

    public String getApplyRangeKey() {
        String keyName = (String)this.applyRangeKey.get();
        if (keyName == null || keyName.trim().isEmpty()) {
            return null;
        }
        return keyName;
    }

    public String getRangeKeyValue() {
        String keyValue = (String)this.rangeKeyValue.get();
        if (keyValue == null || keyValue.trim().isEmpty()) {
            return null;
        }
        return keyValue;
    }

    public boolean isEnableStream() {
        return (Boolean)this.enableStream.get();
    }

    public boolean isEnableContinuousBackups() {
        return (Boolean)this.enableContinuousBackups.get();
    }

    public boolean isEnableTTL() {
        return (Boolean)this.enableTTL.get();
    }

    public int getPurgeLimit() {
        return (Integer)this.purgeLimit.get();
    }

    public String getHTTPProxyHost() {
        return (String)this.httpProxyHost.get();
    }

    public int getHTTPProxyPort() {
        return (Integer)this.httpProxyPort.get();
    }

    public String getHMACSHA256Key() {
        return (String)this.hmacSHA256Key.get();
    }

    public MetricRegistry getMetricRegistry() {
        return (MetricRegistry)this.metricRegistry.get();
    }

    public Properties properties() {
        Properties interpolatedProps = new Properties();
        for (String name : super.properties().stringPropertyNames()) {
            interpolatedProps.setProperty(name, StringPropertyReplacer.replaceProperties((String)super.properties().getProperty(name)));
        }
        return interpolatedProps;
    }

    public void log() {
        Loggers.MAIN_LOG.info("[DS0000] Infinispan DynamoDB store: Endpoint (overrides region): {}", (Object)(this.getEndpoint() != null ? this.getEndpoint() : "not set"));
        Loggers.MAIN_LOG.info("[DS0001] Infinispan DynamoDB store: Region: {}", (Object)this.getRegion());
        Loggers.MAIN_LOG.info("[DS0002] Infinispan DynamoDB store: Item transformer class: {}", (Object)this.getItemTransformerClass().getCanonicalName());
        Loggers.MAIN_LOG.info("[DS0009] Infinispan DynamoDB store: Query executor class: {}", (Object)(this.getQueryExecutorClass() != null ? this.getQueryExecutorClass().getCanonicalName() : "none"));
        Loggers.MAIN_LOG.info("[DS0010] Infinispan DynamoDB store: Indexed attributes: {}", this.getIndexedAttributes() != null ? this.getIndexedAttributes() : "none");
        Loggers.MAIN_LOG.info("[DS0015] Infinispan DynamoDB store: Consistent reads: {}", (Object)this.isConsistentReads());
        Loggers.MAIN_LOG.info("[DS0005] Infinispan DynamoDB store: Capacity to provision: read={} write={}", (Object)this.getProvisionedThroughput().getReadCapacityUnits(), (Object)this.getProvisionedThroughput().getWriteCapacityUnits());
        Loggers.MAIN_LOG.info("[DS0011] Infinispan DynamoDB store: Table encryption at rest: {}", (Object)this.isTableWithEncryptionAtRest());
        Loggers.MAIN_LOG.info("[DS0006] Infinispan DynamoDB store: Table prefix: {}", (Object)(this.getTablePrefix().isEmpty() ? "none" : this.getTablePrefix()));
        Loggers.MAIN_LOG.info("[DS0007] Infinispan DynamoDB store: Apply range key: {}", (Object)(this.getApplyRangeKey() != null ? this.getApplyRangeKey() : "none"));
        Loggers.MAIN_LOG.info("[DS0008] Infinispan DynamoDB store: Range key value: {}", (Object)(this.getRangeKeyValue() != null ? this.getRangeKeyValue() : "none"));
        Loggers.MAIN_LOG.info("[DS0003] Infinispan DynamoDB store: Enable stream: {}", (Object)this.isEnableStream());
        Loggers.MAIN_LOG.info("[DS0012] Infinispan DynamoDB store: Enable continuous backups: {}", (Object)this.isEnableContinuousBackups());
        Loggers.MAIN_LOG.info("[DS0014] Infinispan DynamoDB store: Enable TTL: {}", (Object)this.isEnableTTL());
        Loggers.MAIN_LOG.info("[DS0016] Infinispan DynamoDB store: Expired entries purge limit: {}", new Supplier[]{this::getPurgeLimit});
        Loggers.MAIN_LOG.info("[DS0017] Infinispan DynamoDB store: HTTP proxy host: {}", (Object)(this.getHTTPProxyHost() != null ? this.getHTTPProxyHost() : "none"));
        Loggers.MAIN_LOG.info("[DS0018] Infinispan DynamoDB store: HTTP proxy port: {}", (Object)this.getHTTPProxyPort());
        Loggers.MAIN_LOG.info("[DS0019] Infinispan DynamoDB store: HMAC SHA-256 key: {}", (Object)(this.getHMACSHA256Key() != null ? "configured" : "none"));
        Loggers.MAIN_LOG.info("[DS0013] Infinispan DynamoDB store: Explicit metric registry: {}", (Object)(this.getMetricRegistry() != null ? 1 : 0));
    }
}

