/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb.config;

import com.amazonaws.regions.Regions;
import com.nimbusds.infinispan.persistence.dynamodb.config.Attribute;
import com.nimbusds.infinispan.persistence.dynamodb.config.DynamoDBStoreConfigurationBuilder;
import com.nimbusds.infinispan.persistence.dynamodb.config.Element;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:dynamodb:1.9", root="dynamodb-store"), @Namespace(root="dynamodb-store")})
public class DynamoDBStoreConfigurationParser_1_9
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case DYNAMODB_STORE: {
                this.parseDynamoDBStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseDynamoDBStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder, ClassLoader classLoader) throws XMLStreamException {
        DynamoDBStoreConfigurationBuilder builder = new DynamoDBStoreConfigurationBuilder(persistenceBuilder);
        this.parseDynamoDBStoreAttributes(reader, builder, classLoader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            Parser.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseDynamoDBStoreAttributes(XMLExtendedStreamReader reader, DynamoDBStoreConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block35: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENDPOINT: {
                    builder.endpoint(value);
                    continue block35;
                }
                case REGION: {
                    if (value == null || value.trim().isEmpty()) continue block35;
                    try {
                        builder.region(Regions.fromName((String)value));
                        continue block35;
                    }
                    catch (Exception e) {
                        throw new CacheConfigurationException(e);
                    }
                }
                case ITEM_TRANSFORMER: {
                    try {
                        builder.itemTransformerClass(classLoader.loadClass(value));
                        continue block35;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case QUERY_EXECUTOR: {
                    try {
                        builder.queryExecutorClass(classLoader.loadClass(value));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case INDEXED_ATTRIBUTES: {
                    builder.indexedAttributes((Set)DynamoDBStoreConfigurationParser_1_9.parseStringSet(value));
                    continue block35;
                }
                case CONSISTENT_READS: {
                    builder.consistentReads(Boolean.parseBoolean(value));
                    continue block35;
                }
                case READ_CAPACITY: {
                    try {
                        builder.readCapacity(Long.parseLong(value));
                        continue block35;
                    }
                    catch (NumberFormatException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case WRITE_CAPACITY: {
                    try {
                        builder.writeCapacity(Long.parseLong(value));
                        continue block35;
                    }
                    catch (NumberFormatException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case ENCRYPTION_AT_REST: {
                    builder.tableWithEncryptionAtRest(Boolean.parseBoolean(value));
                    continue block35;
                }
                case TABLE_PREFIX: {
                    builder.tablePrefix(value);
                    continue block35;
                }
                case APPLY_RANGE_KEY: {
                    builder.applyRangeKey(value);
                    continue block35;
                }
                case RANGE_KEY_VALUE: {
                    builder.rangeKeyValue(value);
                    continue block35;
                }
                case ENABLE_STREAM: {
                    builder.enableStream(Boolean.parseBoolean(value));
                    continue block35;
                }
                case ENABLE_CONTINUOUS_BACKUPS: {
                    builder.enableContinuousBackups(Boolean.parseBoolean(value));
                    continue block35;
                }
                case ENABLE_TTL: {
                    builder.enableTTL(Boolean.parseBoolean(value));
                    continue block35;
                }
                case PURGE_LIMIT: {
                    try {
                        builder.purgeLimit(Integer.parseInt(value));
                        continue block35;
                    }
                    catch (NumberFormatException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case HTTP_PROXY_HOST: {
                    if (value == null || value.trim().isEmpty()) continue block35;
                    builder.httpProxyHost(value);
                    continue block35;
                }
                case HTTP_PROXY_PORT: {
                    try {
                        builder.httpProxyPort(Integer.parseInt(value));
                        continue block35;
                    }
                    catch (NumberFormatException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case HMAC_SHA256_KEY: {
                    if (value == null || value.trim().isEmpty()) continue block35;
                    builder.hmacSHA256Key(value);
                    continue block35;
                }
                default: {
                    Parser.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    static Set<String> parseStringSet(String s) {
        if (null == s || s.trim().isEmpty()) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(s.replaceAll("^[,\\s]+", "").split("[,\\s]+")));
    }
}

