/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb.config;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    DYNAMODB_STORE("dynamodb-store");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

