/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb.query;

import com.amazonaws.services.dynamodbv2.document.Index;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.document.utils.NameMap;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.nimbusds.infinispan.persistence.common.InfinispanEntry;
import com.nimbusds.infinispan.persistence.common.query.MatchQuery;
import com.nimbusds.infinispan.persistence.common.query.Query;
import com.nimbusds.infinispan.persistence.common.query.SimpleMatchQuery;
import com.nimbusds.infinispan.persistence.common.query.UnsupportedQueryException;
import com.nimbusds.infinispan.persistence.dynamodb.query.DynamoDBQueryExecutor;
import com.nimbusds.infinispan.persistence.dynamodb.query.DynamoDBQueryExecutorInitContext;
import java.util.Map;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SimpleMatchQueryExecutor<K, V>
implements DynamoDBQueryExecutor<K, V> {
    private DynamoDBQueryExecutorInitContext<K, V> initCtx;

    @Override
    public void init(DynamoDBQueryExecutorInitContext<K, V> initCtx) {
        if (initCtx == null) {
            throw new IllegalArgumentException("The init context must not be null");
        }
        this.initCtx = initCtx;
    }

    static QuerySpec toQuerySpec(SimpleMatchQuery<String, String> simpleMatchQuery) {
        return new QuerySpec().withKeyConditionExpression("#k = :value").withNameMap((Map)new NameMap().with("#k", (String)simpleMatchQuery.getKey())).withValueMap((Map)new ValueMap().withString(":value", (String)simpleMatchQuery.getValue()));
    }

    static ScanSpec toScanSpec(SimpleMatchQuery<String, String> simpleMatchQuery) {
        return new ScanSpec().withFilterExpression("#k = :value").withNameMap((Map)new NameMap().with("#k", (String)simpleMatchQuery.getKey())).withValueMap((Map)new ValueMap().withString(":value", (String)simpleMatchQuery.getValue())).withConsistentRead(Boolean.valueOf(false));
    }

    static SimpleMatchQuery<String, String> toSimpleMatchQuery(MatchQuery<String, String> matchQuery) {
        if (matchQuery instanceof SimpleMatchQuery) {
            return (SimpleMatchQuery)matchQuery;
        }
        Map.Entry entry = matchQuery.getMatchMap().entrySet().iterator().next();
        return new SimpleMatchQuery((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
    }

    public void executeQuery(Query query, Consumer<InfinispanEntry<K, V>> consumer) {
        if (!(query instanceof MatchQuery)) {
            throw new UnsupportedQueryException(query);
        }
        MatchQuery matchQuery = (MatchQuery)query;
        if (matchQuery.getMatchMap().isEmpty()) {
            throw new UnsupportedQueryException(query);
        }
        SimpleMatchQuery<String, String> simpleMatchQuery = SimpleMatchQueryExecutor.toSimpleMatchQuery((MatchQuery<String, String>)matchQuery);
        Index index = this.initCtx.getDynamoDBIndex((String)simpleMatchQuery.getKey());
        if (index != null) {
            ItemCollection items = index.query(SimpleMatchQueryExecutor.toQuerySpec(simpleMatchQuery));
            items.forEach(item -> consumer.accept(this.initCtx.getDynamoDBItemTransformer().toInfinispanEntry((Item)item)));
        } else {
            ItemCollection scanOutcome = this.initCtx.getDynamoDBTable().scan(SimpleMatchQueryExecutor.toScanSpec(simpleMatchQuery));
            scanOutcome.forEach(item -> consumer.accept(this.initCtx.getDynamoDBItemTransformer().toInfinispanEntry((Item)item)));
        }
    }
}

