/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql;

import com.nimbusds.infinispan.persistence.sql.Loggers;
import com.nimbusds.infinispan.persistence.sql.SQLStore;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class DataSources {
    private final Map<String, HikariDataSource> dataSources = new ConcurrentHashMap<String, HikariDataSource>();
    private final Map<String, List<SQLStore<?, ?>>> awaitingStartup = new ConcurrentHashMap();

    DataSources() {
    }

    synchronized void put(String cacheName, HikariDataSource dataSource) {
        this.dataSources.put(cacheName, dataSource);
        List<SQLStore<?, ?>> storedAwaitingStartup = this.awaitingStartup.remove(cacheName);
        if (storedAwaitingStartup == null) {
            Loggers.MAIN_LOG.info("[IS0160] SQL store: No deferred caches found awaiting the connection pool start up of {}", (Object)cacheName);
            return;
        }
        for (SQLStore<?, ?> toStartUp : storedAwaitingStartup) {
            Loggers.MAIN_LOG.info("[IS0161] SQL store: Starting up deferred store for {} using the connection pool of {}", (Object)toStartUp.getCacheName(), (Object)cacheName);
            toStartUp.start();
        }
    }

    HikariDataSource get(String cacheName) {
        return this.dataSources.get(cacheName);
    }

    synchronized void deferStart(String cacheName, SQLStore<?, ?> sqlStore) {
        CopyOnWriteArrayList singletonList = new CopyOnWriteArrayList();
        singletonList.add(sqlStore);
        List existingList = this.awaitingStartup.putIfAbsent(cacheName, singletonList);
        if (existingList != null) {
            existingList.add(sqlStore);
            Loggers.MAIN_LOG.info("[IS0138] SQL store: Deferred startup for store using a shared connection pool: {}", (Object)sqlStore.getCacheName());
        } else {
            Loggers.MAIN_LOG.info("[IS0139] SQL store: Deferred startup for store using a shared connection pool: {}", (Object)sqlStore.getCacheName());
        }
    }

    void remove(String cacheName) {
        this.dataSources.remove(cacheName);
    }
}

