/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql;

import com.nimbusds.infinispan.persistence.common.InfinispanEntry;
import com.nimbusds.infinispan.persistence.sql.Loggers;
import com.nimbusds.infinispan.persistence.sql.SQLRecordTransformer;
import java.util.Date;
import java.util.LinkedList;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

@ThreadSafe
class ExpiredEntryReaper<K, V> {
    private final MarshalledEntryFactory<K, V> marshalledEntryFactory;
    private final DSLContext dsl;
    private final SQLRecordTransformer<K, V> recordTransformer;

    public ExpiredEntryReaper(MarshalledEntryFactory<K, V> marshalledEntryFactory, DSLContext dsl, SQLRecordTransformer<K, V> recordTransformer) {
        assert (marshalledEntryFactory != null);
        this.marshalledEntryFactory = marshalledEntryFactory;
        assert (dsl != null);
        this.dsl = dsl;
        assert (recordTransformer != null);
        this.recordTransformer = recordTransformer;
    }

    public void purge(AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        long now = new Date().getTime();
        LinkedList forDeletion = new LinkedList();
        this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((String)this.recordTransformer.getTableName())).stream().forEach(record -> {
            InfinispanEntry<K, V> infinispanEntry = this.recordTransformer.toInfinispanEntry((Record)record);
            InternalMetadata metadata = infinispanEntry.getMetadata();
            if (metadata == null) {
                return;
            }
            if (metadata.isExpired(now)) {
                forDeletion.add(infinispanEntry.getKey());
            }
        });
        int counter = 0;
        for (Object key : forDeletion) {
            int numDeleted = this.dsl.deleteFrom(DSL.table((String)this.recordTransformer.getTableName())).where(this.recordTransformer.resolveSelectionConditions(key)).execute();
            if (numDeleted != 1) continue;
            purgeListener.entryPurged(key);
            ++counter;
        }
        Loggers.SQL_LOG.debug("[IS0128] SQL store: Purged {} expired {} cache entries", (Object)counter, (Object)this.recordTransformer.getTableName());
    }

    public void purgeExtended(AdvancedCacheExpirationWriter.ExpirationPurgeListener<K, V> purgeListener) {
        long now = new Date().getTime();
        LinkedList forDeletion = new LinkedList();
        this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((String)this.recordTransformer.getTableName())).stream().forEach(record -> {
            InfinispanEntry<K, V> infinispanEntry = this.recordTransformer.toInfinispanEntry((Record)record);
            InternalMetadata metadata = infinispanEntry.getMetadata();
            if (metadata == null) {
                return;
            }
            if (metadata.isExpired(now)) {
                forDeletion.add(infinispanEntry);
            }
        });
        int counter = 0;
        for (InfinispanEntry en : forDeletion) {
            int numDeleted = this.dsl.deleteFrom(DSL.table((String)this.recordTransformer.getTableName())).where(this.recordTransformer.resolveSelectionConditions(en.getKey())).execute();
            if (numDeleted != 1) continue;
            MarshalledEntry marshalledEntry = this.marshalledEntryFactory.newMarshalledEntry(en.getKey(), en.getValue(), en.getMetadata());
            purgeListener.marshalledEntryPurged(marshalledEntry);
            ++counter;
        }
        Loggers.SQL_LOG.debug("[IS0128] SQL store: Purged {} expired {} cache entries", (Object)counter, (Object)this.recordTransformer.getTableName());
    }
}

