/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.nimbusds.infinispan.persistence.sql.HikariPoolName;
import java.util.Properties;

class HikariConfigUtils {
    static Properties removeNonHikariProperties(Properties props) {
        Properties out = new Properties();
        for (Object key : props.keySet()) {
            if (key.toString().startsWith("sqlStore.")) continue;
            out.put(key, props.get(key));
        }
        return out;
    }

    static boolean metricsAlreadyRegistered(HikariPoolName poolName, MetricRegistry metricRegistry) {
        for (String gaugeName : metricRegistry.getGauges().keySet()) {
            if (!gaugeName.contains(poolName.toString())) continue;
            return true;
        }
        return false;
    }

    static boolean healthChecksAlreadyRegistered(HikariPoolName poolName, HealthCheckRegistry healthCheckRegistry) {
        for (String checkName : healthCheckRegistry.getNames()) {
            if (!checkName.contains(poolName.toString()) || !checkName.contains("pool.ConnectivityCheck")) continue;
            return true;
        }
        return false;
    }

    private HikariConfigUtils() {
    }
}

