/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.persistence.spi.PersistenceException;
import org.jooq.Merge;
import org.jooq.SQLDialect;

@ThreadSafe
class JOOQFixes {
    static final Set<SQLDialect> REQUIRE_MERGE_FIX = Collections.unmodifiableSet(new HashSet<SQLDialect>(Arrays.asList(SQLDialect.POSTGRES_9_3, SQLDialect.POSTGRES_9_4, SQLDialect.POSTGRES_9_5)));
    private final boolean pgMergeFixRequired;
    private final String pkConstraintName;

    public JOOQFixes(SQLDialect sqlDialect, String createTableStmt) {
        if (REQUIRE_MERGE_FIX.contains(sqlDialect)) {
            this.pkConstraintName = JOOQFixes.parsePrimaryKeyConstraintName(createTableStmt);
            if (this.pkConstraintName == null) {
                throw new PersistenceException("Couldn't determine primary key constraint name from SQL create table statement: " + createTableStmt);
            }
            this.pgMergeFixRequired = true;
        } else {
            this.pgMergeFixRequired = false;
            this.pkConstraintName = null;
        }
    }

    String fixMergeStatement(Merge mergeStatement) {
        if (!this.pgMergeFixRequired) {
            return mergeStatement.toString();
        }
        return mergeStatement.toString().replace("on conflict ([unknown primary key])", "on conflict on constraint " + this.pkConstraintName);
    }

    static String parsePrimaryKeyConstraintName(String createTableStatement) {
        Pattern p = Pattern.compile(".*CONSTRAINT\\s+(\\w*)\\s+PRIMARY", 10);
        Matcher m = p.matcher(createTableStatement);
        if (!m.find()) {
            return null;
        }
        return m.group(1);
    }
}

