/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.nimbusds.common.monitor.MonitorRegistries;
import com.nimbusds.infinispan.persistence.common.InfinispanEntry;
import com.nimbusds.infinispan.persistence.common.InfinispanStore;
import com.nimbusds.infinispan.persistence.common.query.QueryExecutor;
import com.nimbusds.infinispan.persistence.sql.DataSources;
import com.nimbusds.infinispan.persistence.sql.ExpiredEntryReaper;
import com.nimbusds.infinispan.persistence.sql.HikariConfigUtils;
import com.nimbusds.infinispan.persistence.sql.HikariPoolName;
import com.nimbusds.infinispan.persistence.sql.JOOQFixes;
import com.nimbusds.infinispan.persistence.sql.Loggers;
import com.nimbusds.infinispan.persistence.sql.SQLRecord;
import com.nimbusds.infinispan.persistence.sql.SQLRecordTransformer;
import com.nimbusds.infinispan.persistence.sql.SQLTableTransformer;
import com.nimbusds.infinispan.persistence.sql.SQLTableUtils;
import com.nimbusds.infinispan.persistence.sql.SQLTimers;
import com.nimbusds.infinispan.persistence.sql.config.SQLStoreConfiguration;
import com.nimbusds.infinispan.persistence.sql.query.SQLQueryExecutor;
import com.nimbusds.infinispan.persistence.sql.query.SQLQueryExecutorInitContext;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.reactivex.Flowable;
import java.time.Instant;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.sql.DataSource;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.persistence.Store;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.jooq.DSLContext;
import org.jooq.Merge;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.TableLike;
import org.jooq.conf.RenderNameStyle;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;
import org.reactivestreams.Publisher;

@ThreadSafe
@ConfiguredBy(value=SQLStoreConfiguration.class)
@Store(shared=true)
public class SQLStore<K, V>
extends InfinispanStore<K, V> {
    private SQLStoreConfiguration config;
    private static final DataSources SHARED_DATA_SOURCES = new DataSources();
    private HikariDataSource dataSource;
    private DSLContext sql;
    private SQLRecordTransformer<K, V> sqlRecordTransformer;
    private SQLQueryExecutor<K, V> sqlQueryExecutor;
    private MarshalledEntryFactory<K, V> marshalledEntryFactory;
    private ExpiredEntryReaper<K, V> reaper;
    private SQLTimers timers;
    private JOOQFixes jooqFixes;

    private SQLRecordTransformer<K, V> loadRecordTransformerClass(Class clazz) {
        try {
            Class genClazz = clazz;
            return (SQLRecordTransformer)genClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't load SQL record transformer class: " + e.getMessage(), (Throwable)e);
        }
    }

    private SQLQueryExecutor<K, V> loadQueryExecutorClass(Class clazz) {
        try {
            Class genClazz = clazz;
            return (SQLQueryExecutor)genClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't load SQL query executor class: " + e.getMessage(), (Throwable)e);
        }
    }

    public SQLStoreConfiguration getConfiguration() {
        return this.config;
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public void init(InitializationContext ctx) {
        super.init(ctx);
        this.config = (SQLStoreConfiguration)ctx.getConfiguration();
        Loggers.MAIN_LOG.info("[IS0100] SQL store: Infinispan cache store configuration for {}:", (Object)this.getCacheName());
        this.config.log();
        Loggers.MAIN_LOG.info("[IS0140] SQL store: Expiration thread wake up interval for cache {}: {}", (Object)this.getCacheName(), (Object)ctx.getCache().getCacheConfiguration().expiration().wakeUpInterval());
        Loggers.MAIN_LOG.debug("[IS0101] Loading SQL record transformer class {} for cache {}...", (Object)this.config.getRecordTransformerClass(), (Object)this.getCacheName());
        this.sqlRecordTransformer = this.loadRecordTransformerClass(this.config.getRecordTransformerClass());
        this.sqlRecordTransformer.init(() -> this.config.getSQLDialect());
        this.jooqFixes = new JOOQFixes(this.config.getSQLDialect(), this.sqlRecordTransformer.getCreateTableStatement());
        if (this.config.getQueryExecutorClass() != null) {
            Loggers.MAIN_LOG.debug("[IS0201] Loading optional SQL query executor class {} for cache {}...", (Object)this.config.getQueryExecutorClass(), (Object)this.getCacheName());
            this.sqlQueryExecutor = this.loadQueryExecutorClass(this.config.getQueryExecutorClass());
            this.sqlQueryExecutor.init(new SQLQueryExecutorInitContext<K, V>(){

                @Override
                public DataSource getDataSource() {
                    return SQLStore.this.dataSource;
                }

                @Override
                public SQLRecordTransformer<K, V> getSQLRecordTransformer() {
                    return SQLStore.this.sqlRecordTransformer;
                }

                @Override
                public SQLDialect getSQLDialect() {
                    return SQLStore.this.config.getSQLDialect();
                }
            });
        }
        this.marshalledEntryFactory = ctx.getMarshalledEntryFactory();
        this.timers = new SQLTimers(ctx.getCache().getName() + ".");
        Loggers.MAIN_LOG.info("[IS0102] Initialized SQL external store for cache {} with table {}", (Object)this.getCacheName(), (Object)this.sqlRecordTransformer.getTableName());
    }

    public SQLRecordTransformer<K, V> getSQLRecordTransformer() {
        return this.sqlRecordTransformer;
    }

    public QueryExecutor<K, V> getQueryExecutor() {
        return this.sqlQueryExecutor;
    }

    private HikariDataSource startDataSource() {
        Properties hikariProps = HikariConfigUtils.removeNonHikariProperties(this.config.properties());
        HikariPoolName poolName = HikariPoolName.setDefaultPoolName(hikariProps, this.getCacheName());
        HikariConfig hikariConfig = new HikariConfig(hikariProps);
        MetricRegistry metricRegistry = MonitorRegistries.getMetricRegistry();
        if (HikariConfigUtils.metricsAlreadyRegistered(poolName, metricRegistry)) {
            Loggers.MAIN_LOG.warn("[IS0130] SQL store: Couldn't register Dropwizard metrics: Existing registered metrics for " + this.getCacheName());
        } else {
            hikariConfig.setMetricRegistry((Object)metricRegistry);
        }
        HealthCheckRegistry healthCheckRegistry = MonitorRegistries.getHealthCheckRegistry();
        if (HikariConfigUtils.healthChecksAlreadyRegistered(poolName, healthCheckRegistry)) {
            Loggers.MAIN_LOG.warn("[IS0131] SQL store: Couldn't register Dropwizard health checks: Existing registered health checks for " + this.getCacheName());
        } else {
            hikariConfig.setHealthCheckRegistry((Object)healthCheckRegistry);
        }
        return new HikariDataSource(hikariConfig);
    }

    public void start() {
        if (this.config.getConnectionPool() == null) {
            this.dataSource = this.startDataSource();
            SHARED_DATA_SOURCES.put(this.getCacheName(), this.dataSource);
        } else {
            this.dataSource = SHARED_DATA_SOURCES.get(this.config.getConnectionPool());
            if (this.dataSource == null) {
                SHARED_DATA_SOURCES.deferStart(this.getCacheName(), this);
                return;
            }
        }
        Settings jooqSettings = new Settings();
        if (this.config.getSQLDialect().equals((Object)SQLDialect.H2)) {
            jooqSettings.setRenderNameStyle(RenderNameStyle.AS_IS);
        }
        this.sql = DSL.using((DataSource)this.dataSource, (SQLDialect)this.config.getSQLDialect(), (Settings)jooqSettings);
        if (this.config.createTableIfMissing()) {
            try {
                int rows = this.sql.execute(this.sqlRecordTransformer.getCreateTableStatement());
                if (rows > 0) {
                    Loggers.MAIN_LOG.info("[IS0129] SQL store: Created table {} for cache {}", (Object)this.sqlRecordTransformer.getTableName(), (Object)this.getCacheName());
                }
            }
            catch (Exception e) {
                Loggers.MAIN_LOG.fatal("[IS0103] SQL store: Create table if not exists failed: {}: e", (Object)e.getMessage(), (Object)e);
                throw new PersistenceException(e.getMessage(), (Throwable)e);
            }
            if (this.sqlRecordTransformer instanceof SQLTableTransformer) {
                Loggers.MAIN_LOG.warn("[IS0133] SQL store: Found table transformer");
                List<String> transformQueries = ((SQLTableTransformer)((Object)this.sqlRecordTransformer)).getTransformTableStatements(SQLTableUtils.getColumnNames(DSL.table((String)this.sqlRecordTransformer.getTableName()), this.sql));
                if (transformQueries != null) {
                    for (String query : transformQueries) {
                        Loggers.MAIN_LOG.info("[IS0134] SQL store: About to execute table transform query: " + query);
                        this.sql.execute(query);
                    }
                }
            }
        } else {
            Loggers.MAIN_LOG.info("[IS0132] SQL store: Skipped create table if missing step");
        }
        Loggers.MAIN_LOG.info("[IS0104] Started SQL external store connector for cache {} with table {}", (Object)this.getCacheName(), (Object)this.sqlRecordTransformer.getTableName());
        this.reaper = new ExpiredEntryReaper<K, V>(this.marshalledEntryFactory, this.sql, this.sqlRecordTransformer);
    }

    public void stop() {
        super.stop();
        SHARED_DATA_SOURCES.remove(this.getCacheName());
        if (this.dataSource != null && this.config.getConnectionPool() == null) {
            this.dataSource.close();
        }
        Loggers.MAIN_LOG.info("[IS0105] Stopped SQL store connector for cache {}", (Object)this.getCacheName());
    }

    private K resolveKey(Object key) {
        if (key instanceof byte[]) {
            throw new PersistenceException("Cannot resolve " + this.getCacheName() + " cache key from byte[], enable compatibility mode");
        }
        return (K)key;
    }

    public boolean contains(Object key) {
        Loggers.SQL_LOG.trace("[IS0106] SQL store: Checking {} cache key {}", (Object)this.getCacheName(), key);
        Timer.Context timerCtx = this.timers.loadTimer.time();
        try {
            boolean bl = this.sql.selectOne().from((TableLike)DSL.table((String)this.sqlRecordTransformer.getTableName())).where(this.sqlRecordTransformer.resolveSelectionConditions(this.resolveKey(key))).fetchOne() != null;
            return bl;
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0107] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }

    public MarshalledEntry<K, V> load(Object key) {
        InfinispanEntry<K, V> infinispanEntry;
        Record record;
        Loggers.SQL_LOG.trace("[IS0108] SQL store: Loading {} cache entry with key {}", (Object)this.getCacheName(), key);
        Timer.Context timerCtx = this.timers.loadTimer.time();
        try {
            record = this.sql.selectFrom(DSL.table((String)this.sqlRecordTransformer.getTableName())).where(this.sqlRecordTransformer.resolveSelectionConditions(this.resolveKey(key))).fetchOne();
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0109] {}, {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
        if (record == null) {
            Loggers.SQL_LOG.trace("[IS0110] SQL store: Record with key {} not found", key);
            return null;
        }
        if (Loggers.SQL_LOG.isTraceEnabled()) {
            Loggers.SQL_LOG.trace("[IS0111] SQL store: Retrieved record: {}", (Object)record);
        }
        if ((infinispanEntry = this.sqlRecordTransformer.toInfinispanEntry(record)).isExpired()) {
            Loggers.SQL_LOG.trace("[IS0135] SQL store: Record with key {} expired", key);
            return null;
        }
        return this.marshalledEntryFactory.newMarshalledEntry(infinispanEntry.getKey(), infinispanEntry.getValue(), infinispanEntry.getMetadata());
    }

    public boolean delete(Object key) {
        int deletedRows;
        Loggers.SQL_LOG.trace("[IS0112] SQL store: Deleting {} cache entry with key {}", (Object)this.getCacheName(), key);
        Timer.Context timerCtx = this.timers.deleteTimer.time();
        try {
            deletedRows = this.sql.deleteFrom(DSL.table((String)this.sqlRecordTransformer.getTableName())).where(this.sqlRecordTransformer.resolveSelectionConditions(this.resolveKey(key))).execute();
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0113] {}, {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
        Loggers.SQL_LOG.trace("[IS0113] SQL store: Deleted {} record with key {}", (Object)deletedRows, key);
        if (deletedRows == 1) {
            return true;
        }
        if (deletedRows == 0) {
            return false;
        }
        Loggers.SQL_LOG.error("[IS0114] Too many deleted rows ({}) for key {}", (Object)deletedRows, key);
        throw new PersistenceException("Too many deleted rows for key " + key);
    }

    public void write(MarshalledEntry<? extends K, ? extends V> marshalledEntry) {
        Loggers.SQL_LOG.trace("[IS0115] SQL store: Writing {} cache entry {}", (Object)this.getCacheName(), marshalledEntry);
        Timer.Context timerCtx = this.timers.writeTimer.time();
        try {
            SQLRecord sqlRecord = this.sqlRecordTransformer.toSQLRecord(new InfinispanEntry(marshalledEntry.getKey(), marshalledEntry.getValue(), marshalledEntry.getMetadata()));
            Merge mergeStatement = this.sql.mergeInto(DSL.table((String)this.sqlRecordTransformer.getTableName()), sqlRecord.getFields().keySet()).key(sqlRecord.getKeyColumns()).values(sqlRecord.getFields().values());
            String sqlStatement = this.jooqFixes.fixMergeStatement(mergeStatement);
            int rows = this.sql.execute(sqlStatement);
            if (rows != 1) {
                if (SQLDialect.MYSQL.equals((Object)this.config.getSQLDialect()) && rows == 2) {
                    return;
                }
                Loggers.SQL_LOG.error("[IS0116] SQL insert / update for key {} in table {} failed: Rows {}", marshalledEntry.getKey(), (Object)this.sqlRecordTransformer.getTableName(), (Object)rows);
                throw new PersistenceException("(Synthetic) SQL MERGE failed: Rows " + rows);
            }
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0117] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        Loggers.SQL_LOG.trace("[IS0118] SQL store: Processing key filter for {} cache: fetchValue={} fetchMetadata={}", (Object)this.getCacheName(), (Object)fetchValue, (Object)fetchMetadata);
        Instant now = Instant.now();
        return Flowable.using(() -> ((Timer)this.timers.processTimer).time(), ignore -> Flowable.fromIterable((Iterable)this.sql.selectFrom(DSL.table((String)this.sqlRecordTransformer.getTableName())).fetch()).map(this.sqlRecordTransformer::toInfinispanEntry).filter(infinispanEntry -> filter == null || filter.test((Object)infinispanEntry.getKey())).filter(infinispanEntry -> !infinispanEntry.isExpired(now)).map(infinispanEntry -> this.marshalledEntryFactory.newMarshalledEntry(infinispanEntry.getKey(), infinispanEntry.getValue(), infinispanEntry.getMetadata())).doOnError(e -> Loggers.SQL_LOG.error("[IS0119] {}: {}", (Object)e.getMessage(), e)), Timer.Context::stop);
    }

    public int size() {
        int count;
        Loggers.SQL_LOG.trace("[IS0120] SQL store: Counting {} records", (Object)this.getCacheName());
        try {
            count = this.sql.fetchCount(DSL.table((String)this.sqlRecordTransformer.getTableName()));
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0121] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        Loggers.SQL_LOG.trace("[IS0122] SQL store: Counted {} {} records", (Object)count, (Object)this.getCacheName());
        return count;
    }

    public void clear() {
        int numDeleted;
        Loggers.SQL_LOG.trace("[IS0123] SQL store: Clearing {} records", (Object)this.getCacheName());
        try {
            numDeleted = this.sql.deleteFrom(DSL.table((String)this.sqlRecordTransformer.getTableName())).execute();
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0124] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        Loggers.SQL_LOG.info("[IS0125] SQL store: Cleared {} {} records", (Object)numDeleted, (Object)this.sqlRecordTransformer.getTableName());
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        Loggers.SQL_LOG.trace("[IS0126] SQL store: Purging {} cache entries", (Object)this.getCacheName());
        Timer.Context timerCtx = this.timers.purgeTimer.time();
        try {
            executor.execute(() -> this.reaper.purge(purgeListener));
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0127] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException("Purge exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }

    public void purge(Executor executor, AdvancedCacheExpirationWriter.ExpirationPurgeListener<K, V> purgeListener) {
        Loggers.SQL_LOG.trace("[IS0150] SQL store: Purging {} cache entries", (Object)this.getCacheName());
        Timer.Context timerCtx = this.timers.purgeTimer.time();
        try {
            executor.execute(() -> this.reaper.purgeExtended(purgeListener));
        }
        catch (Exception e) {
            Loggers.SQL_LOG.error("[IS0151] {}: {}", (Object)e.getMessage(), (Object)e);
            throw new PersistenceException("Purge exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            timerCtx.stop();
        }
    }
}

