/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql.config;

import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.infinispan.persistence.sql.Loggers;
import com.nimbusds.infinispan.persistence.sql.SQLStore;
import com.nimbusds.infinispan.persistence.sql.config.SQLStoreConfigurationBuilder;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.jooq.SQLDialect;

@Immutable
@BuiltBy(value=SQLStoreConfigurationBuilder.class)
@ConfigurationFor(value=SQLStore.class)
public class SQLStoreConfiguration
extends AbstractStoreConfiguration
implements LoggableConfiguration {
    static final AttributeDefinition<Class> RECORD_TRANSFORMER = AttributeDefinition.builder((String)"recordTransformer", null, Class.class).build();
    static final AttributeDefinition<Class> QUERY_EXECUTOR = AttributeDefinition.builder((String)"queryExecutor", null, Class.class).build();
    static final AttributeDefinition<SQLDialect> SQL_DIALECT = AttributeDefinition.builder((String)"sqlDialect", (Object)SQLDialect.DEFAULT).build();
    static final AttributeDefinition<Boolean> CREATE_TABLE_IF_MISSING = AttributeDefinition.builder((String)"createTableIfMissing", (Object)Boolean.TRUE).build();
    static final AttributeDefinition<String> CONNECTION_POOL = AttributeDefinition.builder((String)"connectionPool", null, String.class).build();
    private final Attribute<Class> recordTransformerClass;
    private final Attribute<Class> queryExecutorClass;
    private final Attribute<SQLDialect> sqlDialect;
    private final Attribute<Boolean> createTableIfMissing;
    private final Attribute<String> connectionPool;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SQLStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{RECORD_TRANSFORMER, QUERY_EXECUTOR, SQL_DIALECT, CREATE_TABLE_IF_MISSING, CONNECTION_POOL});
    }

    public SQLStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration asyncConfig, SingletonStoreConfiguration singletonStoreConfig) {
        super(attributes, asyncConfig, singletonStoreConfig);
        this.recordTransformerClass = attributes.attribute(RECORD_TRANSFORMER);
        assert (this.recordTransformerClass != null);
        this.queryExecutorClass = attributes.attribute(QUERY_EXECUTOR);
        this.sqlDialect = attributes.attribute(SQL_DIALECT);
        assert (this.sqlDialect != null);
        this.createTableIfMissing = attributes.attribute(CREATE_TABLE_IF_MISSING);
        this.connectionPool = attributes.attribute(CONNECTION_POOL);
    }

    public Class getRecordTransformerClass() {
        return (Class)this.recordTransformerClass.get();
    }

    public Class getQueryExecutorClass() {
        return (Class)this.queryExecutorClass.get();
    }

    public SQLDialect getSQLDialect() {
        return (SQLDialect)this.sqlDialect.get();
    }

    public boolean createTableIfMissing() {
        return (Boolean)this.createTableIfMissing.get();
    }

    public String getConnectionPool() {
        return (String)this.connectionPool.get();
    }

    public Properties properties() {
        Properties interpolatedProps = new Properties();
        for (String name : super.properties().stringPropertyNames()) {
            interpolatedProps.setProperty(name, StringPropertyReplacer.replaceProperties((String)super.properties().getProperty(name)));
        }
        return interpolatedProps;
    }

    public void log() {
        Loggers.MAIN_LOG.info("[IS0000] Infinispan SQL store: Record transformer class: {} ", (Object)this.getRecordTransformerClass().getCanonicalName());
        Loggers.MAIN_LOG.info("[IS0001] Infinispan SQL store: Query executor class: {} ", (Object)(this.getQueryExecutorClass() != null ? this.getQueryExecutorClass().getCanonicalName() : "not specified"));
        Loggers.MAIN_LOG.info("[IS0002] Infinispan SQL store: SQL dialect: {} ", this.sqlDialect);
        Loggers.MAIN_LOG.info("[IS0004] Infinispan SQL store: Create table if missing: {} ", this.createTableIfMissing);
        Loggers.MAIN_LOG.info("[IS0008] Infinispan SQL store: Connection pool reference: {} ", (Object)(this.getConnectionPool() != null ? this.getConnectionPool() : "not specified"));
        if (StringUtils.isNotBlank((CharSequence)this.properties().getProperty("dataSourceClassName"))) {
            Loggers.MAIN_LOG.info("[IS0005] Infinispan SQL store: Data source class name: {} ", (Object)this.properties().getProperty("dataSourceClassName"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.properties().getProperty("dataSource.url"))) {
            Loggers.MAIN_LOG.info("[IS0006] Infinispan SQL store: Data source URL: {} ", (Object)this.properties().getProperty("dataSource.url"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.properties().getProperty("jdbcUrl"))) {
            Loggers.MAIN_LOG.info("[IS0003] Infinispan SQL store: JDBC URL: {} ", (Object)this.properties().getProperty("jdbcUrl"));
        }
    }
}

