/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql.config;

import com.nimbusds.infinispan.persistence.sql.config.Attribute;
import com.nimbusds.infinispan.persistence.sql.config.Element;
import com.nimbusds.infinispan.persistence.sql.config.SQLStoreConfigurationBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.jooq.SQLDialect;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:sql:2.7", root="sql-store"), @Namespace(root="sql-store")})
public class SQLStoreConfigurationParser27
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case SQL_STORE: {
                this.parseSQLStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseSQLStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder, ClassLoader classLoader) throws XMLStreamException {
        SQLStoreConfigurationBuilder builder = new SQLStoreConfigurationBuilder(persistenceBuilder);
        this.parseSQLStoreAttributes(reader, builder, classLoader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            Parser.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseSQLStoreAttributes(XMLExtendedStreamReader reader, SQLStoreConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RECORD_TRANSFORMER: {
                    try {
                        builder.recordTransformerClass(classLoader.loadClass(value));
                        continue block11;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case QUERY_EXECUTOR: {
                    try {
                        builder.queryExecutorClass(classLoader.loadClass(value));
                        continue block11;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheConfigurationException((Exception)e);
                    }
                }
                case SQL_DIALECT: {
                    builder.sqlDialect(SQLDialect.valueOf((String)value.toUpperCase()));
                    continue block11;
                }
                case CREATE_TABLE_IF_MISSING: {
                    if ("true".equals(value)) {
                        builder.createTableIfMissing(true);
                        continue block11;
                    }
                    if ("false".equals(value)) {
                        builder.createTableIfMissing(false);
                        continue block11;
                    }
                    throw new CacheConfigurationException("Invalid " + attribute.getLocalName() + ": Must be true or false");
                }
                case CONNECTION_POOL: {
                    if (value == null || value.trim().isEmpty()) continue block11;
                    builder.connectionPool(value);
                    continue block11;
                }
                default: {
                    Parser.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

