/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.sql.transformers;

import com.nimbusds.infinispan.persistence.sql.transformers.CollectionDataType;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import org.infinispan.persistence.spi.PersistenceException;
import org.jooq.Record;
import org.jooq.SQLDialect;

@ThreadSafe
public class SQLFieldTransformer {
    private CollectionDataType collectionDataType;

    public SQLFieldTransformer(SQLDialect sqlDialect) {
        if (SQLDialect.H2.equals((Object)sqlDialect)) {
            this.collectionDataType = CollectionDataType.ARRAY;
        } else if (SQLDialect.MYSQL.equals((Object)sqlDialect)) {
            this.collectionDataType = CollectionDataType.JSON;
        } else if (SQLDialect.POSTGRES.family().equals((Object)sqlDialect.family())) {
            this.collectionDataType = CollectionDataType.ARRAY;
        } else if (SQLDialect.SQLSERVER2016.equals((Object)sqlDialect)) {
            this.collectionDataType = CollectionDataType.JSON;
        } else {
            throw new IllegalArgumentException("Unsupported SQL dialect: " + sqlDialect);
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Object toSQLCollection(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (CollectionDataType.ARRAY.equals((Object)this.collectionDataType)) {
            String[] out = new String[collection.size()];
            int i = 0;
            for (Object item : collection) {
                out[i++] = item.toString();
            }
            return out;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object item : collection) {
            jsonArray.add((Object)item.toString());
        }
        return jsonArray.toJSONString();
    }

    public static String toSQLString(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isEmpty()) {
            return null;
        }
        return jsonObject.toJSONString();
    }

    public static Timestamp toTimestamp(Instant date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.toEpochMilli());
    }

    public String[] parseSQLStringCollection(String fieldName, Record sqlRecord) {
        if (CollectionDataType.ARRAY.equals((Object)this.collectionDataType)) {
            return (String[])sqlRecord.get(fieldName, String[].class);
        }
        return SQLFieldTransformer.parseStringArrayFromJSONArrayString((String)sqlRecord.get(fieldName, String.class));
    }

    static String[] parseStringArrayFromJSONArrayString(String s) {
        if (s == null) {
            return null;
        }
        try {
            JSONArray jsonArray = (JSONArray)JSONValue.parseStrict((String)s);
            return (String[])jsonArray.toArray((Object[])new String[0]);
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't parse JSON array of strings: " + e.getMessage(), (Throwable)e);
        }
    }

    public static JSONObject parseJSONObject(String jsonObjectString) {
        if (jsonObjectString == null) {
            return null;
        }
        try {
            return (JSONObject)JSONValue.parseStrict((String)jsonObjectString);
        }
        catch (ClassCastException | ParseException e) {
            throw new PersistenceException("Couldn't parse JSON object: " + e.getMessage(), e);
        }
    }

    public static Instant parseInstant(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return Instant.ofEpochMilli(timestamp.getTime());
    }
}

