/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.ldap;

import com.nimbusds.infinispan.persistence.ldap.InfinispanEntry;
import com.nimbusds.infinispan.persistence.ldap.LDAPWriteStrategy;
import com.nimbusds.infinispan.persistence.ldap.LDAPWriteStrategyResolver;
import java.util.Date;
import net.jcip.annotations.Immutable;

@Immutable
public class CreatedTimestampLDAPWriteStrategyResolver<K, V>
implements LDAPWriteStrategyResolver<K, V> {
    public static final long DEFAULT_RECENT_AGE_MS = 50L;
    private final long recentAgeMs;

    public CreatedTimestampLDAPWriteStrategyResolver() {
        this(50L);
    }

    public CreatedTimestampLDAPWriteStrategyResolver(long recentAgeMs) {
        assert (recentAgeMs >= 0L);
        this.recentAgeMs = recentAgeMs;
    }

    @Override
    public LDAPWriteStrategy resolveLDAPWriteStrategy(InfinispanEntry<K, V> infinispanEntry) {
        if (infinispanEntry.getMetadata() == null) {
            return LDAPWriteStrategy.getDefault();
        }
        if (infinispanEntry.getMetadata().created() < 0L) {
            return LDAPWriteStrategy.getDefault();
        }
        Date now = new Date();
        if (infinispanEntry.getMetadata().created() + this.recentAgeMs > now.getTime()) {
            return LDAPWriteStrategy.TRY_LDAP_ADD_FIRST;
        }
        return LDAPWriteStrategy.TRY_LDAP_MODIFY_FIRST;
    }
}

