/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.ldap;

import com.nimbusds.common.appendable.Appendable;
import com.nimbusds.infinispan.persistence.ldap.InfinispanEntry;
import com.nimbusds.infinispan.persistence.ldap.LDAPEntry;
import com.nimbusds.infinispan.persistence.ldap.LDAPEntryTransformer;
import com.nimbusds.infinispan.persistence.ldap.backend.LDAPConnector;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.tuple.Pair;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.PersistenceException;

@ThreadSafe
class ExpiredEntryReaper<K, V> {
    private final LDAPConnector ldapConnector;
    private final LDAPEntryTransformer<K, V> entityTransformer;

    public ExpiredEntryReaper(LDAPConnector ldapConnector, LDAPEntryTransformer<K, V> entityTransformer) {
        assert (ldapConnector != null);
        this.ldapConnector = ldapConnector;
        assert (entityTransformer != null);
        this.entityTransformer = entityTransformer;
    }

    public int purge(AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        long now = new Date().getTime();
        LinkedList forDeletion = new LinkedList();
        this.ldapConnector.retrieveEntries((Appendable<ReadOnlyEntry>)((Appendable)ldapEntry -> {
            InfinispanEntry<K, V> infinispanEntry = this.entityTransformer.toInfinispanEntry(new LDAPEntry((ReadOnlyEntry)ldapEntry));
            if (infinispanEntry.getMetadata().isExpired(now)) {
                try {
                    Pair pair = Pair.of((Object)new DN(ldapEntry.getDN()), infinispanEntry.getKey());
                    forDeletion.add(pair);
                }
                catch (LDAPException e) {
                    throw new PersistenceException(e.getMessage(), (Throwable)e);
                }
            }
        }));
        AtomicInteger deleteCounter = new AtomicInteger(0);
        for (Pair pair : forDeletion) {
            if (!this.ldapConnector.deleteEntry((DN)pair.getLeft())) continue;
            purgeListener.entryPurged(pair.getRight());
            deleteCounter.incrementAndGet();
        }
        return deleteCounter.get();
    }
}

