/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.ldap;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;

public class InternalMetadataBuilder
implements Metadata.Builder {
    private long created = -1L;
    private long lastUsed = -1L;
    private long lifespan = -1L;
    private long maxIdle = -1L;
    private EntryVersion entryVersion;

    public InternalMetadataBuilder created(Date date) {
        return this.created(date != null ? date.getTime() : -1L);
    }

    public InternalMetadataBuilder created(long l) {
        this.created = l;
        return this;
    }

    public InternalMetadataBuilder lastUsed(Date date) {
        return this.lastUsed(date != null ? date.getTime() : -1L);
    }

    public InternalMetadataBuilder lastUsed(long l) {
        this.lastUsed = l;
        return this;
    }

    public InternalMetadataBuilder lifespan(long l, TimeUnit timeUnit) {
        this.lifespan = l < 0L ? -1L : timeUnit.toMillis(l);
        return this;
    }

    public InternalMetadataBuilder lifespan(long l) {
        this.lifespan = l;
        return this;
    }

    public InternalMetadataBuilder maxIdle(long l, TimeUnit timeUnit) {
        this.maxIdle = l < 0L ? -1L : timeUnit.toMillis(l);
        return this;
    }

    public InternalMetadataBuilder maxIdle(long l) {
        this.maxIdle = l;
        return this;
    }

    public InternalMetadataBuilder version(EntryVersion entryVersion) {
        this.entryVersion = entryVersion;
        return this;
    }

    public InternalMetadata build() {
        final InternalMetadataBuilder builder = this;
        return new InternalMetadata(){

            public long created() {
                return InternalMetadataBuilder.this.created;
            }

            public long lastUsed() {
                return InternalMetadataBuilder.this.lastUsed;
            }

            public boolean isExpired(long now) {
                long expiry = this.expiryTime();
                return expiry > 0L && expiry <= now;
            }

            public long expiryTime() {
                long muet;
                long lset = InternalMetadataBuilder.this.lifespan > -1L ? InternalMetadataBuilder.this.created + InternalMetadataBuilder.this.lifespan : -1L;
                long l = muet = InternalMetadataBuilder.this.maxIdle > -1L ? InternalMetadataBuilder.this.lastUsed + InternalMetadataBuilder.this.maxIdle : -1L;
                if (lset == -1L) {
                    return muet;
                }
                if (muet == -1L) {
                    return lset;
                }
                return Math.min(lset, muet);
            }

            public long lifespan() {
                return InternalMetadataBuilder.this.lifespan;
            }

            public long maxIdle() {
                return InternalMetadataBuilder.this.maxIdle;
            }

            public EntryVersion version() {
                return InternalMetadataBuilder.this.entryVersion;
            }

            public Metadata.Builder builder() {
                return builder;
            }
        };
    }

    public Metadata.Builder merge(Metadata metadata) {
        if (this.lifespan == -1L) {
            this.lifespan = metadata.lifespan();
        }
        if (this.maxIdle == -1L) {
            this.maxIdle = metadata.maxIdle();
        }
        if (this.entryVersion == null) {
            this.entryVersion = metadata.version();
        }
        return this;
    }
}

