/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.ldap;

import com.nimbusds.common.appendable.Appendable;
import com.nimbusds.infinispan.persistence.ldap.ExpiredEntryReaper;
import com.nimbusds.infinispan.persistence.ldap.InfinispanEntry;
import com.nimbusds.infinispan.persistence.ldap.LDAPEntry;
import com.nimbusds.infinispan.persistence.ldap.LDAPEntryTransformer;
import com.nimbusds.infinispan.persistence.ldap.LDAPStoreConfiguration;
import com.nimbusds.infinispan.persistence.ldap.LDAPWriteStrategy;
import com.nimbusds.infinispan.persistence.ldap.Loggers;
import com.nimbusds.infinispan.persistence.ldap.backend.LDAPConnector;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;

@ThreadSafe
@ConfiguredBy(value=LDAPStoreConfiguration.class)
public class LDAPStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private InitializationContext ctx;
    private LDAPStoreConfiguration config;
    private LDAPConnector ldapConnector;
    private LDAPEntryTransformer<K, V> ldapEntryTransformer;
    private MarshalledEntryFactory<K, V> marshalledEntryFactory;
    private ExpiredEntryReaper<K, V> reaper;

    private LDAPEntryTransformer<K, V> loadEntryTransformerClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (LDAPEntryTransformer)clazz.newInstance();
        }
        catch (Exception e) {
            throw new PersistenceException("Couldn't load LDAP entry transformer class: " + e.getMessage(), (Throwable)e);
        }
    }

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.config = (LDAPStoreConfiguration)ctx.getConfiguration();
        Loggers.MAIN_LOG.debug("[IL0201] LDAP store configuration properties for cache {}:", new Object[]{ctx.getCache().getName()});
        this.config.log();
        Loggers.MAIN_LOG.debug("[IL0202] Loading LDAP entry transformer class {} for cache {}...", new Object[]{this.config.ldapDirectory.entryTransformer, ctx.getCache().getName()});
        this.ldapEntryTransformer = this.loadEntryTransformerClass(this.config.ldapDirectory.entryTransformer);
        this.marshalledEntryFactory = ctx.getMarshalledEntryFactory();
        Loggers.MAIN_LOG.info("[IL0203] Initialized LDAP external store for cache {}", new Object[]{ctx.getCache().getName()});
    }

    public void start() {
        if (this.ldapConnector != null) {
            throw new IllegalStateException("LDAP store connector already started");
        }
        this.ldapConnector = new LDAPConnector((LDAPStoreConfiguration)this.ctx.getConfiguration(), this.ctx.getCache().getName(), this.ldapEntryTransformer.getModifiableAttributes(), this.ldapEntryTransformer.includesAttributesWithOptions());
        Loggers.MAIN_LOG.info("[IL0204] Started LDAP external store connector for cache {}", new Object[]{this.ctx.getCache().getName()});
        this.reaper = new ExpiredEntryReaper<K, V>(this.ldapConnector, this.ldapEntryTransformer);
    }

    public void stop() {
        if (this.ldapConnector != null) {
            this.ldapConnector.shutdown();
            Loggers.MAIN_LOG.info("[IL0205] Stopped LDAP external store connector for cache {}", new Object[]{this.ctx != null ? this.ctx.getCache().getName() : "null"});
        }
    }

    private K resolveKey(Object key) {
        if (key instanceof byte[]) {
            throw new PersistenceException("Cannot resolve " + this.ctx.getCache().getName() + " cache key from byte[], enable compatibility mode");
        }
        return (K)key;
    }

    public boolean contains(Object key) {
        Loggers.LDAP_LOG.trace("[IL0250] LDAP store: Checking {} cache key {}", new Object[]{this.ctx.getCache().getName(), key});
        DN dn = new DN(this.ldapEntryTransformer.resolveRDN(this.resolveKey(key)), this.config.ldapDirectory.baseDN);
        return this.ldapConnector.entryExists(dn);
    }

    public MarshalledEntry<K, V> load(Object key) {
        Loggers.LDAP_LOG.trace("[IL0251] LDAP store: Loading {} cache entry with key {}", new Object[]{this.ctx.getCache().getName(), key});
        DN dn = new DN(this.ldapEntryTransformer.resolveRDN(this.resolveKey(key)), this.config.ldapDirectory.baseDN);
        ReadOnlyEntry ldapEntry = this.ldapConnector.retrieveEntry(dn);
        if (ldapEntry == null) {
            return null;
        }
        InfinispanEntry<K, V> infinispanEntry = this.ldapEntryTransformer.toInfinispanEntry(new LDAPEntry(ldapEntry));
        return this.marshalledEntryFactory.newMarshalledEntry(infinispanEntry.getKey(), infinispanEntry.getValue(), infinispanEntry.getMetadata());
    }

    public boolean delete(Object key) {
        Loggers.LDAP_LOG.trace("[IL0252] LDAP store: Deleting {} cache entry with key {}", new Object[]{this.ctx.getCache().getName(), key});
        DN dn = new DN(this.ldapEntryTransformer.resolveRDN(this.resolveKey(key)), this.config.ldapDirectory.baseDN);
        return this.ldapConnector.deleteEntry(dn);
    }

    public void write(MarshalledEntry<? extends K, ? extends V> marshalledEntry) {
        Loggers.LDAP_LOG.trace("[IL0253] LDAP store: Writing {} cache entry {}", new Object[]{this.ctx.getCache().getName(), marshalledEntry});
        LDAPEntry ldapEntry = this.ldapEntryTransformer.toLDAPEntry(this.config.ldapDirectory.baseDN, new InfinispanEntry<Object, Object>(marshalledEntry.getKey(), marshalledEntry.getValue(), marshalledEntry.getMetadata()));
        LDAPWriteStrategy writeStrategy = ldapEntry.getWriteStrategy();
        if (writeStrategy != null) {
            Loggers.LDAP_LOG.trace("[IL0263] LDAP store: Entry transformer suggested {} write strategy", new Object[]{writeStrategy});
        } else {
            writeStrategy = LDAPWriteStrategy.getDefault();
            Loggers.LDAP_LOG.trace("[IL0264] LDAP store: Defaulted to {} write strategy", new Object[]{writeStrategy});
        }
        switch (writeStrategy) {
            case TRY_LDAP_ADD_FIRST: {
                if (this.ldapConnector.addEntry(ldapEntry.getEntry())) {
                    Loggers.LDAP_LOG.trace("[IL0256] LDAP store: Added new {} cache entry with DN {}", new Object[]{this.ctx.getCache().getName(), ldapEntry.getEntry().getDN()});
                    return;
                }
                if (this.ldapConnector.replaceEntry(ldapEntry.getEntry())) {
                    Loggers.LDAP_LOG.trace("[IL0257] LDAP store: Replaced {} cache entry with DN {}", new Object[]{this.ctx.getCache().getName(), ldapEntry.getEntry().getDN()});
                    return;
                }
                if (this.ldapConnector.addEntry(ldapEntry.getEntry())) break;
                throw new PersistenceException("Failed recovery from concurrent LDAP delete (" + this.ctx.getCache().getName() + " cache): " + ldapEntry.getEntry().getDN());
            }
            case TRY_LDAP_MODIFY_FIRST: {
                if (this.ldapConnector.replaceEntry(ldapEntry.getEntry())) {
                    Loggers.LDAP_LOG.trace("[IL0265] LDAP store: Replaced {} cache entry with DN {}", new Object[]{this.ctx.getCache().getName(), ldapEntry.getEntry().getDN()});
                    return;
                }
                if (this.ldapConnector.addEntry(ldapEntry.getEntry())) {
                    Loggers.LDAP_LOG.trace("[IL0266] LDAP store: Added new {} cache entry with DN {}", new Object[]{this.ctx.getCache().getName(), ldapEntry.getEntry().getDN()});
                    return;
                }
                if (this.ldapConnector.replaceEntry(ldapEntry.getEntry())) break;
                throw new PersistenceException("Failed recovery from concurrent LDAP add (" + this.ctx.getCache().getName() + " cache): " + ldapEntry.getEntry().getDN());
            }
            default: {
                throw new PersistenceException("Unexpected LDAP write strategy: " + (Object)((Object)writeStrategy));
            }
        }
    }

    public void process(KeyFilter<? super K> keyFilter, AdvancedCacheLoader.CacheLoaderTask<K, V> cacheLoaderTask, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        Loggers.LDAP_LOG.trace("[IL0262] LDAP store: Processing key filter for {} cache: fetchValue={} fetchMetadata=", new Object[]{this.ctx.getCache().getName(), fetchValue, fetchMetadata});
        TaskContextImpl taskContext = new TaskContextImpl();
        executor.execute(() -> this.lambda$process$4((AdvancedCacheLoader.TaskContext)taskContext, keyFilter, cacheLoaderTask));
    }

    public int size() {
        Loggers.LDAP_LOG.trace("[IL0258] LDAP store: Counting {} cache entries", new Object[]{this.ctx.getCache().getName()});
        int count = this.ldapConnector.countEntries();
        Loggers.LDAP_LOG.trace("[IL0259] LDAP store: Counted {} {} cache entries", new Object[]{count, this.ctx.getCache().getName()});
        return count;
    }

    public void clear() {
        Loggers.LDAP_LOG.trace("[IL0260] LDAP store: Clearing {} cache entries", new Object[]{this.ctx.getCache().getName()});
        int numDeleted = this.ldapConnector.deleteEntries();
        Loggers.LDAP_LOG.debug("[IL0254] LDAP store: Cleared {} {} cache entries", new Object[]{numDeleted, this.ctx.getCache().getName()});
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        Loggers.LDAP_LOG.trace("[IL0261] LDAP store: Purging {} cache entries", new Object[]{this.ctx.getCache().getName()});
        AtomicInteger numPurged = new AtomicInteger();
        executor.execute(() -> numPurged.set(this.reaper.purge(purgeListener)));
        Loggers.LDAP_LOG.debug("[IL0255] LDAP store: Purged {} expired {} cache entries", new Object[]{numPurged.get(), this.ctx.getCache().getName()});
    }

    private /* synthetic */ void lambda$process$4(AdvancedCacheLoader.TaskContext taskContext, KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask) {
        this.ldapConnector.retrieveEntries((Appendable<ReadOnlyEntry>)((Appendable)ldapEntry -> {
            if (taskContext.isStopped()) {
                return;
            }
            InfinispanEntry<K, V> infinispanEntry = this.ldapEntryTransformer.toInfinispanEntry(new LDAPEntry((ReadOnlyEntry)ldapEntry));
            if (keyFilter.accept(infinispanEntry.getKey())) {
                MarshalledEntry marshalledEntry = this.marshalledEntryFactory.newMarshalledEntry(infinispanEntry.getKey(), infinispanEntry.getValue(), infinispanEntry.getMetadata());
                try {
                    cacheLoaderTask.processEntry(marshalledEntry, taskContext);
                }
                catch (InterruptedException e) {
                    throw new PersistenceException(e.getMessage(), (Throwable)e);
                }
            }
        }));
    }
}

