/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.ldap;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.CustomKeyStoreConfiguration;
import com.nimbusds.common.config.CustomTrustStoreConfiguration;
import com.nimbusds.common.config.DirectoryUser;
import com.nimbusds.common.config.LDAPServerConnectionPoolDetails;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.infinispan.persistence.ldap.LDAPStore;
import com.nimbusds.infinispan.persistence.ldap.LDAPStoreConfigurationBuilder;
import com.nimbusds.infinispan.persistence.ldap.Loggers;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Map;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections4.MapUtils;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;

@Immutable
@BuiltBy(value=LDAPStoreConfigurationBuilder.class)
@ConfigurationFor(value=LDAPStore.class)
public class LDAPStoreConfiguration
extends AbstractStoreConfiguration
implements LoggableConfiguration {
    public final LDAPServerConnectionPoolDetails ldapServer;
    public final DirectoryUser ldapUser;
    public final LDAPDirectory ldapDirectory;
    public final CustomTrustStoreConfiguration customTrustStore;
    public final CustomKeyStoreConfiguration customKeyStore;

    public LDAPStoreConfiguration(Properties properties) {
        this(false, false, false, null, null, false, true, properties);
    }

    public LDAPStoreConfiguration(boolean purgeOnStartup, boolean fetchPersistentState, boolean ignoreModifications, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, boolean preload, boolean shared, Properties properties) {
        super(purgeOnStartup, fetchPersistentState, ignoreModifications, async, singletonStore, preload, shared, properties);
        if (MapUtils.isEmpty((Map)properties)) {
            throw new ConfigurationException("Missing LDAP store configuration properties, check the service documentation");
        }
        try {
            this.ldapServer = new LDAPServerConnectionPoolDetails("ldapServer.", properties);
            this.ldapUser = new DirectoryUser("ldapUser.", properties);
            this.ldapDirectory = new LDAPDirectory(properties);
            this.customTrustStore = new CustomTrustStoreConfiguration("customTrustStore.", properties);
            this.customKeyStore = new CustomKeyStoreConfiguration("customKeyStore.", properties);
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey() + ": Value: " + e.getPropertyValue());
        }
    }

    public void log() {
        this.ldapServer.log();
        this.ldapUser.log();
        this.ldapDirectory.log();
        this.customTrustStore.log();
        this.customKeyStore.log();
    }

    public static class LDAPDirectory
    implements LoggableConfiguration {
        public final DN baseDN;
        public final int pageSize;
        public final String entryTransformer;

        public LDAPDirectory(Properties props) throws PropertyParseException {
            PropertyRetriever pr = new PropertyRetriever(props);
            String dnString = null;
            try {
                dnString = pr.getString("ldapDirectory.baseDN");
                this.baseDN = new DN(dnString);
            }
            catch (LDAPException e) {
                throw new PropertyParseException("Invalid DN", "ldapDirectory.baseDN", dnString);
            }
            this.pageSize = pr.getInt("ldapDirectory.pageSize");
            if (this.pageSize < 0) {
                throw new PropertyParseException("The page size must be 0 (paging disabled) or positive", "ldapDirectory.pageSize", this.pageSize + "");
            }
            this.entryTransformer = pr.getString("ldapDirectory.entryTransformer");
        }

        public void log() {
            Loggers.MAIN_LOG.info("[IL0000] Infinispan LDAP store: Directory base DN: {} ", new Object[]{this.baseDN});
            Loggers.MAIN_LOG.info("[IL0001] Infinispan LDAP store: Page size: {} ", new Object[]{this.pageSize});
            Loggers.MAIN_LOG.info("[IL0002] Infinispan LDAP store: Entry transformer class: {} ", new Object[]{this.entryTransformer});
        }
    }
}

