/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.ldap.backend;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class LDAPModifyRequestFactory {
    private final Set<String> modifiableAttributes;

    public LDAPModifyRequestFactory(Set<String> attributes) {
        assert (!attributes.isEmpty());
        assert (!attributes.contains("objectClass"));
        this.modifiableAttributes = attributes;
    }

    public Set<String> getModifiableAttributes() {
        return this.modifiableAttributes;
    }

    public ModifyRequest composeModifyRequest(Entry entry) {
        LinkedList<Modification> mods = new LinkedList<Modification>();
        LinkedList<String> updatedAttributes = new LinkedList<String>();
        for (Attribute attr : entry.getAttributes()) {
            if (!this.getModifiableAttributes().contains(attr.getBaseName())) continue;
            mods.add(new Modification(ModificationType.REPLACE, attr.getName(), attr.getValues()));
            updatedAttributes.add(attr.getBaseName());
        }
        for (String supAttr : this.getModifiableAttributes()) {
            if (updatedAttributes.contains(supAttr)) continue;
            mods.add(new Modification(ModificationType.REPLACE, supAttr));
        }
        return new ModifyRequest(entry.getDN(), mods);
    }

    public ModifyRequest composeModifyRequest(Entry newEntry, Entry oldEntry) {
        String[] attrs = this.modifiableAttributes.toArray(new String[this.modifiableAttributes.size()]);
        List mods = Entry.diff((Entry)oldEntry, (Entry)newEntry, (boolean)true, (String[])attrs);
        if (mods.isEmpty()) {
            return null;
        }
        return new ModifyRequest(newEntry.getDN(), mods);
    }
}

