/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.security.KeyStore;
import java.security.Provider;

public class PKCS11Utils {
    public static boolean isPKCS11Key(JWK jwk) {
        KeyStore keyStore = jwk.getKeyStore();
        if (keyStore == null) {
            return false;
        }
        Provider provider = keyStore.getProvider();
        if (provider == null) {
            return false;
        }
        return provider.getName().contains("PKCS11");
    }

    public static boolean hasPKCS11Key(JWKSet jwkSet) {
        for (JWK jwk : jwkSet.getKeys()) {
            if (!PKCS11Utils.isPKCS11Key(jwk)) continue;
            return true;
        }
        return false;
    }

    private PKCS11Utils() {
    }
}

