/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class AuthorizationRequest
implements Request {
    private final ResponseType rt;
    private final ClientID clientID;
    private final URL redirectURI;
    private final Scope scope;
    private final State state;

    public AuthorizationRequest(ResponseType rt, ClientID clientID) {
        this(rt, clientID, null, null, null);
    }

    public AuthorizationRequest(ResponseType rt, ClientID clientID, URL redirectURI, Scope scope, State state) {
        if (rt == null) {
            throw new IllegalArgumentException("The response type must not be null");
        }
        this.rt = rt;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        this.redirectURI = redirectURI;
        this.scope = scope;
        this.state = state;
    }

    public ResponseType getResponseType() {
        return this.rt;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public URL getRedirectURI() {
        return this.redirectURI;
    }

    public Scope getScope() {
        return this.scope;
    }

    public State getState() {
        return this.state;
    }

    public Map<String, String> toParameters() throws SerializeException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("response_type", this.rt.toString());
        params.put("client_id", this.clientID.getValue());
        if (this.redirectURI != null) {
            params.put("redirect_uri", this.redirectURI.toString());
        }
        if (this.scope != null) {
            params.put("scope", this.scope.toString());
        }
        if (this.state != null) {
            params.put("state", this.state.getValue());
        }
        return params;
    }

    public String toQueryString() throws SerializeException {
        return URLUtils.serializeParameters(this.toParameters());
    }

    public HTTPRequest toHTTPRequest(HTTPRequest.Method method, URL url) throws SerializeException {
        HTTPRequest httpRequest;
        if (method.equals((Object)HTTPRequest.Method.GET)) {
            httpRequest = new HTTPRequest(HTTPRequest.Method.GET, url);
        } else if (method.equals((Object)HTTPRequest.Method.POST)) {
            httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        } else {
            throw new IllegalArgumentException("The HTTP request method must be GET or POST");
        }
        httpRequest.setQuery(this.toQueryString());
        return httpRequest;
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) throws SerializeException {
        return this.toHTTPRequest(HTTPRequest.Method.GET, url);
    }

    public static AuthorizationRequest parse(Map<String, String> params) throws ParseException {
        String v = params.get("client_id");
        if (StringUtils.isBlank((CharSequence)v)) {
            throw new ParseException("Missing \"client_id\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        ClientID clientID = new ClientID(v);
        v = params.get("redirect_uri");
        URL redirectURI = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            try {
                redirectURI = new URL(v);
            }
            catch (MalformedURLException e) {
                throw new ParseException("Invalid \"redirect_uri\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, e);
            }
        }
        State state = State.parse(params.get("state"));
        v = params.get("response_type");
        ResponseType rt = null;
        try {
            rt = ResponseType.parse(v);
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage(), OAuth2Error.UNSUPPORTED_RESPONSE_TYPE, redirectURI, state, e);
        }
        v = params.get("scope");
        Scope scope = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            scope = Scope.parse(v);
        }
        return new AuthorizationRequest(rt, clientID, redirectURI, scope, state);
    }

    public static AuthorizationRequest parse(String query) throws ParseException {
        return AuthorizationRequest.parse(URLUtils.parseParameters(query));
    }

    public static AuthorizationRequest parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing URL query string");
        }
        return AuthorizationRequest.parse(query);
    }
}

