/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AuthorizationResponse
implements Response {
    private final URL redirectURI;
    private final State state;

    protected AuthorizationResponse(URL redirectURI, State state) {
        if (redirectURI == null) {
            throw new IllegalArgumentException("The redirect URI must not be null");
        }
        this.redirectURI = redirectURI;
        this.state = state;
    }

    public URL getRedirectURI() {
        return this.redirectURI;
    }

    public State getState() {
        return this.state;
    }

    public abstract Map<String, String> toParameters() throws SerializeException;

    public abstract URL toURI() throws SerializeException;

    @Override
    public HTTPResponse toHTTPResponse() throws SerializeException {
        HTTPResponse response = new HTTPResponse(302);
        response.setLocation(this.toURI());
        return response;
    }

    public static AuthorizationResponse parse(URL redirectURI, Map<String, String> params) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)params.get("error"))) {
            return AuthorizationErrorResponse.parse(redirectURI, params);
        }
        return AuthorizationSuccessResponse.parse(redirectURI, params);
    }

    public static AuthorizationResponse parse(URL uri) throws ParseException {
        Map<String, String> params = null;
        if (uri.getRef() != null) {
            params = URLUtils.parseParameters(uri.getRef());
        } else if (uri.getQuery() != null) {
            params = URLUtils.parseParameters(uri.getQuery());
        } else {
            throw new ParseException("Missing URL fragment or query string");
        }
        return AuthorizationResponse.parse(URLUtils.getBaseURL(uri), params);
    }

    public static AuthorizationResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 302) {
            throw new ParseException("Unexpected HTTP status code, must be 302 (Found): " + httpResponse.getStatusCode());
        }
        URL location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirect URL / HTTP Location header");
        }
        return AuthorizationResponse.parse(location);
    }
}

