/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import net.jcip.annotations.Immutable;
import org.apache.commons.codec.binary.Base64;

@Immutable
public final class ClientSecretBasic
extends ClientAuthentication {
    private final ClientID clientID;
    private final Secret secret;

    public ClientSecretBasic(ClientID clientID, Secret secret) {
        super(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        if (secret == null) {
            throw new IllegalArgumentException("The client secret must not be null");
        }
        this.secret = secret;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public Secret getClientSecret() {
        return this.secret;
    }

    public String toHTTPAuthorizationHeader() {
        String b64 = null;
        try {
            String encodedClientID = URLEncoder.encode(this.clientID.toString(), "UTF-8");
            String encodedSecret = URLEncoder.encode(this.secret.getValue(), "UTF-8");
            StringBuilder sb = new StringBuilder(encodedClientID);
            sb.append(':');
            sb.append(encodedSecret);
            b64 = Base64.encodeBase64String((byte[])sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "Basic " + b64;
    }

    @Override
    public void applyTo(HTTPRequest httpRequest) {
        httpRequest.setAuthorization(this.toHTTPAuthorizationHeader());
    }

    public static ClientSecretBasic parse(String header) throws ParseException {
        String[] parts = header.split("\\s");
        if (parts.length != 2) {
            throw new ParseException("Unexpected number of HTTP Authorization header value parts: " + parts.length);
        }
        if (!parts[0].equalsIgnoreCase("Basic")) {
            throw new ParseException("HTTP authentication must be \"Basic\"");
        }
        try {
            String credentialsString = new String(Base64.decodeBase64((String)parts[1]), "utf-8");
            String[] credentials = credentialsString.split(":", 2);
            if (credentials.length != 2) {
                throw new ParseException("Missing credentials delimiter \":\"");
            }
            String decodedClientID = URLDecoder.decode(credentials[0], "utf-8");
            String decodedSecret = URLDecoder.decode(credentials[1], "utf-8");
            return new ClientSecretBasic(new ClientID(decodedClientID), new Secret(decodedSecret));
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public static ClientSecretBasic parse(HTTPRequest httpRequest) throws ParseException {
        String header = httpRequest.getAuthorization();
        if (header == null) {
            throw new ParseException("Missing HTTP Authorization header");
        }
        return ClientSecretBasic.parse(header);
    }
}

