/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.net.URL;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientDeleteRequest
extends ProtectedResourceRequest {
    public ClientDeleteRequest(BearerAccessToken accessToken) {
        super(accessToken);
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    @Override
    public HTTPRequest toHTTPRequest(URL url) {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.DELETE, url);
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        return httpRequest;
    }

    public static ClientDeleteRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.DELETE);
        String authzHeaderValue = httpRequest.getAuthorization();
        BearerAccessToken accessToken = BearerAccessToken.parse(authzHeaderValue);
        return new ClientDeleteRequest(accessToken);
    }
}

