/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.token;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.util.Map;
import net.minidev.json.JSONObject;

public final class TokenPair {
    private final AccessToken accessToken;
    private final RefreshToken refreshToken;

    public TokenPair(AccessToken accessToken, RefreshToken refreshToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public JSONObject toJSONObject() {
        JSONObject o = this.accessToken.toJSONObject();
        if (this.refreshToken != null) {
            o.putAll((Map)this.refreshToken.toJSONObject());
        }
        return o;
    }

    public String toString() {
        return "TokenPair [accessToken=" + this.accessToken + " refreshToken=" + this.refreshToken + "]";
    }
}

