/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.claims;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.Address;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.Gender;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONObject;

public class UserInfo
extends ClaimsSet {
    private static final Set<String> stdClaimNames = new LinkedHashSet<String>();

    public static Set<String> getStandardClaimNames() {
        return Collections.unmodifiableSet(stdClaimNames);
    }

    public UserInfo(Subject sub) {
        this.setClaim("sub", sub.getValue());
    }

    public UserInfo(JSONObject jsonObject) {
        super(jsonObject);
        if (this.getSubject() == null) {
            throw new IllegalArgumentException("Missing or invalid \"sub\" claim");
        }
    }

    public Subject getSubject() {
        String value = this.getStringClaim("sub");
        if (value != null) {
            return new Subject(value);
        }
        return null;
    }

    public String getName() {
        return this.getStringClaim("name");
    }

    public String getName(LangTag langTag) {
        return this.getStringClaim("name", langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.getLangTaggedClaim("name", String.class);
    }

    public void setName(String name) {
        this.setClaim("name", name);
    }

    public void setName(String name, LangTag langTag) {
        this.setClaim("name", name, langTag);
    }

    public String getGivenName() {
        return this.getStringClaim("given_name");
    }

    public String getGivenName(LangTag langTag) {
        return this.getStringClaim("given_name", langTag);
    }

    public Map<LangTag, String> getGivenNameEntries() {
        return this.getLangTaggedClaim("given_name", String.class);
    }

    public void setGivenName(String givenName) {
        this.setClaim("given_name", givenName);
    }

    public void setGivenName(String givenName, LangTag langTag) {
        this.setClaim("given_name", givenName, langTag);
    }

    public String getFamilyName() {
        return this.getStringClaim("family_name");
    }

    public String getFamilyName(LangTag langTag) {
        return this.getStringClaim("family_name", langTag);
    }

    public Map<LangTag, String> getFamilyNameEntries() {
        return this.getLangTaggedClaim("family_name", String.class);
    }

    public void setFamilyName(String familyName) {
        this.setClaim("family_name", familyName);
    }

    public void setFamilyName(String familyName, LangTag langTag) {
        this.setClaim("family_name", familyName, langTag);
    }

    public String getMiddleName() {
        return this.getStringClaim("middle_name");
    }

    public String getMiddleName(LangTag langTag) {
        return this.getStringClaim("middle_name", langTag);
    }

    public Map<LangTag, String> getMiddleNameEntries() {
        return this.getLangTaggedClaim("middle_name", String.class);
    }

    public void setMiddleName(String middleName) {
        this.setClaim("middle_name", middleName);
    }

    public void setMiddleName(String middleName, LangTag langTag) {
        this.setClaim("middle_name", middleName, langTag);
    }

    public String getNickname() {
        return this.getStringClaim("nickname");
    }

    public String getNickname(LangTag langTag) {
        return this.getStringClaim("nickname", langTag);
    }

    public Map<LangTag, String> getNicknameEntries() {
        return this.getLangTaggedClaim("nickname", String.class);
    }

    public void setNickname(String nickname) {
        this.setClaim("nickname", nickname);
    }

    public void setNickname(String nickname, LangTag langTag) {
        this.setClaim("nickname", nickname, langTag);
    }

    public String getPreferredUsername() {
        return this.getStringClaim("preferred_username");
    }

    public void setPreferredUsername(String preferredUsername) {
        this.setClaim("preferred_username", preferredUsername);
    }

    public URL getProfile() {
        return this.getURLClaim("profile");
    }

    public void setProfile(URL profile) {
        this.setURLClaim("profile", profile);
    }

    public URL getPicture() {
        return this.getURLClaim("picture");
    }

    public void setPicture(URL picture) {
        this.setURLClaim("picture", picture);
    }

    public URL getWebsite() {
        return this.getURLClaim("website");
    }

    public void setWebsite(URL website) {
        this.setURLClaim("website", website);
    }

    public InternetAddress getEmail() {
        return this.getEmailClaim("email");
    }

    public void setEmail(InternetAddress email) {
        this.setEmailClaim("email", email);
    }

    public Boolean getEmailVerified() {
        return this.getBooleanClaim("email_verified");
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.setClaim("email_verified", emailVerified);
    }

    public Gender getGender() {
        String value = this.getStringClaim("gender");
        if (value == null) {
            return null;
        }
        return new Gender(value);
    }

    public void setGender(Gender gender) {
        if (gender != null) {
            this.setClaim("gender", gender.getValue());
        } else {
            this.setClaim("gender", null);
        }
    }

    public String getBirthdate() {
        return this.getStringClaim("birthdate");
    }

    public void setBirthdate(String birthdate) {
        this.setClaim("birthdate", birthdate);
    }

    public String getZoneinfo() {
        return this.getStringClaim("zoneinfo");
    }

    public void setZoneinfo(String zoneinfo) {
        this.setClaim("zoneinfo", zoneinfo);
    }

    public String getLocale() {
        return this.getStringClaim("locale");
    }

    public void setLocale(String locale) {
        this.setClaim("locale", locale);
    }

    public String getPhoneNumber() {
        return this.getStringClaim("phone_number");
    }

    public void setPhoneNumber(String phoneNumber) {
        this.setClaim("phone_number", phoneNumber);
    }

    public Boolean getPhoneNumberVerified() {
        return this.getBooleanClaim("phone_number_verified");
    }

    public void setPhoneNumberVerified(Boolean phoneNumberVerified) {
        this.setClaim("phone_number_verified", phoneNumberVerified);
    }

    public Address getAddress() {
        return this.getAddress(null);
    }

    public Address getAddress(LangTag langTag) {
        String name = langTag != null ? "address#" + langTag : "address";
        JSONObject jsonObject = this.getClaim(name, JSONObject.class);
        if (jsonObject == null) {
            return null;
        }
        return new Address(jsonObject);
    }

    public Map<LangTag, Address> getAddressEntries() {
        Map<LangTag, JSONObject> entriesIn = this.getLangTaggedClaim("address", JSONObject.class);
        HashMap<LangTag, Address> entriesOut = new HashMap<LangTag, Address>();
        for (Map.Entry<LangTag, JSONObject> en : entriesIn.entrySet()) {
            entriesOut.put(en.getKey(), new Address(en.getValue()));
        }
        return entriesOut;
    }

    public void setAddress(Address address) {
        if (address != null) {
            this.setClaim("address", address.getJSONObject());
        } else {
            this.setClaim("address", null);
        }
    }

    public void setAddress(Address address, LangTag langTag) {
        String key;
        String string = key = langTag == null ? "address" : "address#" + langTag;
        if (address != null) {
            this.setClaim(key, address.getJSONObject());
        } else {
            this.setClaim(key, null);
        }
    }

    public Date getUpdatedTime() {
        return this.getDateClaim("updated_at");
    }

    public void setUpdatedTime(Date updatedTime) {
        this.setDateClaim("updated_at", updatedTime);
    }

    static {
        stdClaimNames.add("sub");
        stdClaimNames.add("name");
        stdClaimNames.add("given_name");
        stdClaimNames.add("family_name");
        stdClaimNames.add("middle_name");
        stdClaimNames.add("nickname");
        stdClaimNames.add("preferred_username");
        stdClaimNames.add("profile");
        stdClaimNames.add("picture");
        stdClaimNames.add("website");
        stdClaimNames.add("email");
        stdClaimNames.add("email_verified");
        stdClaimNames.add("gender");
        stdClaimNames.add("birthdate");
        stdClaimNames.add("zoneinfo");
        stdClaimNames.add("locale");
        stdClaimNames.add("phone_number");
        stdClaimNames.add("phone_number_verified");
        stdClaimNames.add("address");
        stdClaimNames.add("updated_at");
    }
}

