/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.openid.connect.sdk.OIDCAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.op.ResolveException;
import com.nimbusds.openid.connect.sdk.util.JWTDecoder;
import com.nimbusds.openid.connect.sdk.util.Resource;
import com.nimbusds.openid.connect.sdk.util.ResourceRetriever;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class OIDCAuthorizationRequestResolver {
    private final JWTDecoder jwtDecoder;
    private final ResourceRetriever jwtRetriever;

    public OIDCAuthorizationRequestResolver() {
        this(null, null);
    }

    public OIDCAuthorizationRequestResolver(JWTDecoder jwtDecoder) {
        this(jwtDecoder, null);
    }

    public OIDCAuthorizationRequestResolver(JWTDecoder jwtDecoder, ResourceRetriever jwtRetriever) {
        this.jwtDecoder = jwtDecoder;
        this.jwtRetriever = jwtRetriever;
    }

    public JWTDecoder getJWTDecoder() {
        return this.jwtDecoder;
    }

    public ResourceRetriever getJWTRetriever() {
        return this.jwtRetriever;
    }

    private JWT retrieveJWT(URL url) throws ResolveException {
        if (this.jwtRetriever == null) {
            throw new ResolveException("OpenID Connect request object cannot be resolved: No JWT retriever is configured");
        }
        Resource resource = null;
        try {
            resource = this.jwtRetriever.retrieveResource(url);
        }
        catch (IOException e) {
            throw new ResolveException("Couldn't retrieve OpenID Connect request object: " + e.getMessage(), e);
        }
        try {
            return JWTParser.parse((String)resource.getContent());
        }
        catch (java.text.ParseException e) {
            throw new ResolveException("Couldn't parse OpenID Connect request object: " + e.getMessage(), e);
        }
    }

    private ReadOnlyJWTClaimsSet decodeRequestObject(JWT requestObject) throws ResolveException {
        if (this.jwtDecoder == null) {
            throw new ResolveException("OpenID Connect request object cannot be decoded: No JWT decoder is configured");
        }
        try {
            return this.jwtDecoder.decodeJWT(requestObject);
        }
        catch (JOSEException e) {
            throw new ResolveException("Couldn't decode OpenID Connect request object JWT: " + e.getMessage(), e);
        }
        catch (java.text.ParseException e) {
            throw new ResolveException("Couldn't parse OpenID Connect request object JWT claims: " + e.getMessage(), e);
        }
    }

    public static Map<String, String> reformatClaims(ReadOnlyJWTClaimsSet claimsSet) throws ResolveException {
        Map claims = claimsSet.getAllClaims();
        HashMap reformattedClaims = new HashMap();
        for (Map.Entry entry : claims.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                reformattedClaims.put(entry.getKey(), (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                reformattedClaims.put(entry.getKey(), bool.toString());
                continue;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                reformattedClaims.put(entry.getKey(), number.toString());
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)value;
                reformattedClaims.put(entry.getKey(), jsonObject.toString());
                continue;
            }
            throw new ResolveException("Couldn't process JWT claim \"" + (String)entry.getKey() + "\": Unsupported type");
        }
        return Collections.unmodifiableMap(reformattedClaims);
    }

    public OIDCAuthorizationRequest resolve(OIDCAuthorizationRequest request) throws ResolveException {
        if (!request.specifiesRequestObject()) {
            return request;
        }
        JWT jwt = request.getRequestURI() != null ? this.retrieveJWT(request.getRequestURI()) : request.getRequestObject();
        ReadOnlyJWTClaimsSet jwtClaims = this.decodeRequestObject(jwt);
        Map<String, String> requestObjectParams = OIDCAuthorizationRequestResolver.reformatClaims(jwtClaims);
        HashMap<String, String> finalParams = new HashMap<String, String>();
        try {
            finalParams.putAll(request.toParameters());
        }
        catch (SerializeException e) {
            throw new ResolveException("Couldn't resolve final OpenID Connect authorization request: " + e.getMessage(), e);
        }
        finalParams.putAll(requestObjectParams);
        OIDCAuthorizationRequest finalAuthzRequest = null;
        try {
            finalAuthzRequest = OIDCAuthorizationRequest.parse(finalParams);
        }
        catch (ParseException e) {
            throw new ResolveException("Couldn't create final OpenID Connect authorization request: " + e.getMessage(), e);
        }
        return new OIDCAuthorizationRequest(finalAuthzRequest.getResponseType(), finalAuthzRequest.getScope(), finalAuthzRequest.getClientID(), finalAuthzRequest.getRedirectURI(), finalAuthzRequest.getState(), finalAuthzRequest.getNonce(), finalAuthzRequest.getDisplay(), finalAuthzRequest.getPrompt(), finalAuthzRequest.getMaxAge(), finalAuthzRequest.getUILocales(), finalAuthzRequest.getClaimsLocales(), finalAuthzRequest.getIDTokenHint(), finalAuthzRequest.getLoginHint(), finalAuthzRequest.getACRValues(), finalAuthzRequest.getClaims());
    }
}

