/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore;

import com.nimbusds.common.appendable.Appendable;
import com.nimbusds.common.id.SID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.sessionstore.Configuration;
import com.nimbusds.sessionstore.SubjectSession;
import com.nimbusds.sessionstore.SubjectSessionStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class AbstractSubjectSessionStore
implements SubjectSessionStore {
    protected final Configuration config;

    protected AbstractSubjectSessionStore(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("The session configuration must not be null");
        }
        this.config = config;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void get(Set<SID> sidSet, Appendable<Map.Entry<SID, SubjectSession>> appendable) {
        for (SID sid : sidSet) {
            SubjectSession session = this.get(sid);
            if (session == null) continue;
            appendable.append((Object)new ImmutablePair((Object)sid, (Object)session));
        }
    }

    @Override
    public int countSubjects() {
        final AtomicInteger counter = new AtomicInteger(0);
        this.getSubjects(new Appendable<Subject>(){

            public void append(Subject subject) {
                counter.incrementAndGet();
            }
        });
        return counter.get();
    }
}

