/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.DateUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.AMR;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

@Immutable
public final class SubjectAuthentication {
    private final Subject subject;
    private final Date authTime;
    private final ACR acr;
    private final List<AMR> amrList;

    public SubjectAuthentication(Subject subject) {
        this(subject, null, null, null);
    }

    public SubjectAuthentication(Subject subject, Date authTime) {
        this(subject, authTime, null, null);
    }

    public SubjectAuthentication(Subject subject, Date authTime, ACR acr, List<AMR> amrList) {
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.subject = subject;
        this.authTime = authTime == null ? new Date() : authTime;
        this.acr = acr;
        this.amrList = amrList;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Date getTime() {
        return this.authTime;
    }

    public ACR getACR() {
        return this.acr;
    }

    public List<AMR> getAMRList() {
        return this.amrList;
    }

    public boolean hasExpired(long maxAuthAge) {
        if (maxAuthAge <= 0L) {
            return false;
        }
        Date now = new Date();
        Date authExpirationDate = new Date(this.authTime.getTime() + maxAuthAge * 1000L);
        return now.after(authExpirationDate);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SubjectAuthentication)) {
            return false;
        }
        SubjectAuthentication other = (SubjectAuthentication)object;
        if (!this.subject.equals((Object)other.getSubject())) {
            return false;
        }
        if (!this.authTime.equals(other.getTime())) {
            return false;
        }
        if (this.acr == null && other.getACR() != null) {
            return false;
        }
        if (this.acr != null && !this.acr.equals((Object)other.getACR())) {
            return false;
        }
        if (this.amrList == null && other.getAMRList() != null) {
            return false;
        }
        return this.amrList == null || this.amrList.equals(other.getAMRList());
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"sub", (Object)this.subject.getValue());
        o.put((Object)"auth_time", (Object)DateUtils.toSecondsSinceEpoch((Date)this.authTime));
        if (this.acr != null) {
            o.put((Object)"acr", (Object)this.acr.getValue());
        }
        if (this.amrList != null) {
            JSONArray amrArray = new JSONArray();
            for (AMR amr : this.amrList) {
                amrArray.add((Object)amr.getValue());
            }
            o.put((Object)"amr", (Object)amrArray);
        }
        return o;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static SubjectAuthentication parse(JSONObject jsonObject) throws ParseException {
        Subject subject = new Subject(JSONObjectUtils.getString((JSONObject)jsonObject, (String)"sub"));
        Date authDate = null;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"auth_time")) {
            authDate = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong((JSONObject)jsonObject, (String)"auth_time"));
        }
        ACR acr = null;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"acr")) {
            acr = new ACR(JSONObjectUtils.getString((JSONObject)jsonObject, (String)"acr"));
        }
        ArrayList<AMR> amrList = null;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"amr")) {
            amrList = new ArrayList<AMR>();
            for (String amrValue : JSONObjectUtils.getStringArray((JSONObject)jsonObject, (String)"amr")) {
                amrList.add(new AMR(amrValue));
            }
        }
        return new SubjectAuthentication(subject, authDate, acr, amrList);
    }

    public static SubjectAuthentication parse(String jsonObjectString) throws ParseException {
        return SubjectAuthentication.parse(JSONObjectUtils.parse((String)jsonObjectString));
    }
}

