/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.DateUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.sessionstore.SubjectAuthentication;
import java.util.Date;
import net.jcip.annotations.NotThreadSafe;
import net.minidev.json.JSONObject;

@NotThreadSafe
public final class SubjectSession {
    public static final long DEFAULT_MAX_LIFETIME = 0L;
    public static final long DEFAULT_AUTH_LIFETIME = 0L;
    public static final long DEFAULT_MAX_IDLE_TIME = 0L;
    private SubjectAuthentication subjectAuth;
    private final Date creationTime;
    private Date lastAccessTime;
    private long maxLifetime;
    private long authLifetime;
    private long maxIdleTime;
    private JSONObject claims;
    private JSONObject data;

    public SubjectSession(Subject subject) {
        this(new SubjectAuthentication(subject));
    }

    public SubjectSession(SubjectAuthentication subjectAuth) {
        this(subjectAuth, null, 0L, 0L, 0L, null, null);
    }

    public SubjectSession(SubjectAuthentication subjectAuth, Date creationTime, long maxLifetime, long authLifetime, long maxIdleTime, JSONObject claims, JSONObject data) {
        if (subjectAuth == null) {
            throw new IllegalArgumentException("The subject authentication must not be null");
        }
        this.subjectAuth = subjectAuth;
        if (creationTime == null) {
            Date now;
            this.creationTime = now = new Date();
            this.lastAccessTime = now;
        } else {
            this.creationTime = creationTime;
            this.lastAccessTime = creationTime;
        }
        this.maxLifetime = maxLifetime;
        this.authLifetime = authLifetime;
        this.maxIdleTime = maxIdleTime;
        this.claims = claims;
        this.data = data;
    }

    public Subject getSubject() {
        return this.subjectAuth.getSubject();
    }

    public SubjectAuthentication getSubjectAuthentication() {
        return this.subjectAuth;
    }

    public void updateSubjectAuthentication(SubjectAuthentication subjectAuth) {
        if (!this.subjectAuth.getSubject().equals((Object)subjectAuth.getSubject())) {
            throw new IllegalArgumentException("The subject of the new authentication must be identical");
        }
        this.subjectAuth = subjectAuth;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public long getAuthLifetime() {
        return this.authLifetime;
    }

    public void setAuthLifetime(long authLifetime) {
        this.authLifetime = authLifetime;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        if (lastAccessTime == null) {
            throw new IllegalArgumentException("The last access time must not be null");
        }
        this.lastAccessTime = lastAccessTime;
    }

    public Date updateLastAccessTime() {
        Date now;
        this.lastAccessTime = now = new Date();
        return now;
    }

    public boolean hasExpired() {
        return this.hasExpired(new Date());
    }

    public boolean hasExpired(Date now) {
        if (this.maxIdleTime > 1L && now.after(new Date(this.lastAccessTime.getTime() + this.maxIdleTime * 60L * 1000L))) {
            return true;
        }
        if (this.authLifetime > 1L && now.after(new Date(this.subjectAuth.getTime().getTime() + this.authLifetime * 60L * 1000L))) {
            return true;
        }
        return this.maxLifetime > 1L && now.after(new Date(this.creationTime.getTime() + this.maxLifetime * 60L * 1000L));
    }

    public JSONObject getClaims() {
        return this.claims;
    }

    public void setClaims(JSONObject claims) {
        this.claims = claims;
    }

    public JSONObject getData() {
        return this.data;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public JSONObject toJSONObject() {
        JSONObject o = this.subjectAuth.toJSONObject();
        o.put((Object)"creation_time", (Object)DateUtils.toSecondsSinceEpoch((Date)this.creationTime));
        if (this.maxLifetime != 0L) {
            o.put((Object)"max_life", (Object)this.maxLifetime);
        }
        if (this.authLifetime != 0L) {
            o.put((Object)"auth_life", (Object)this.authLifetime);
        }
        if (this.maxIdleTime != 0L) {
            o.put((Object)"max_idle", (Object)this.maxIdleTime);
        }
        if (this.claims != null) {
            o.put((Object)"claims", (Object)this.claims);
        }
        if (this.data != null) {
            o.put((Object)"data", (Object)this.data);
        }
        return o;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static SubjectSession parse(JSONObject jsonObject) throws ParseException {
        SubjectAuthentication subjectAuth = SubjectAuthentication.parse(jsonObject);
        Date created = null;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"creation_time")) {
            created = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong((JSONObject)jsonObject, (String)"creation_time"));
        }
        long maxLifetime = 0L;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"max_life")) {
            maxLifetime = JSONObjectUtils.getLong((JSONObject)jsonObject, (String)"max_life");
        }
        long authLifetime = 0L;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"auth_life")) {
            authLifetime = JSONObjectUtils.getLong((JSONObject)jsonObject, (String)"auth_life");
        }
        long maxIdleTime = 0L;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"max_idle")) {
            maxIdleTime = JSONObjectUtils.getLong((JSONObject)jsonObject, (String)"max_idle");
        }
        JSONObject claims = null;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"claims")) {
            claims = JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"claims");
        }
        JSONObject data = null;
        if (JSONObjectUtils.containsKey((JSONObject)jsonObject, (String)"data")) {
            data = JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"data");
        }
        return new SubjectSession(subjectAuth, created, maxLifetime, authLifetime, maxIdleTime, claims, data);
    }

    public static SubjectSession parse(String jsonObjectString) throws ParseException {
        return SubjectSession.parse(JSONObjectUtils.parse((String)jsonObjectString));
    }
}

