/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.impl;

import com.nimbusds.common.appendable.Appendable;
import com.nimbusds.common.id.SID;
import com.nimbusds.sessionstore.SubjectSession;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.ws.rs.WebApplicationException;

public class JSONObjectWriter
implements Appendable<Map.Entry<SID, SubjectSession>> {
    private final Writer writer;
    private boolean first;

    public JSONObjectWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("The writer must not be null");
        }
        this.writer = writer;
        this.first = true;
    }

    public void writeStart() {
        try {
            this.writer.write(123);
        }
        catch (IOException e) {
            throw new WebApplicationException("Couldn't write JSON object: " + e.getMessage(), (Throwable)e);
        }
    }

    public void append(Map.Entry<SID, SubjectSession> entry) {
        if (entry == null || entry.getKey() == null || entry.getValue() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.first) {
            this.first = false;
        } else {
            sb.append(',');
        }
        sb.append(entry.getKey().toJSONString());
        sb.append(':');
        sb.append(entry.getValue().toJSONObject().toJSONString());
        try {
            this.writer.write(sb.toString());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new WebApplicationException("Couldn't write JSON object: " + e.getMessage(), (Throwable)e);
        }
    }

    public void writeEnd() {
        try {
            this.writer.write(125);
            this.writer.close();
        }
        catch (IOException e) {
            throw new WebApplicationException("Couldn't write JSON object: " + e.getMessage(), (Throwable)e);
        }
    }
}

