/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.impl;

import com.nimbusds.common.id.SID;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.sessionstore.SubjectSession;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONValue;

class JSONSerializers {
    JSONSerializers() {
    }

    public static String toJSONString(Identifier identifier) {
        if (identifier == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(JSONValue.escape((String)identifier.getValue()));
        sb.append('\"');
        return sb.toString();
    }

    public static String toJSONObjectString(Map<SID, SubjectSession> map) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<SID, SubjectSession> en : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(en.getKey().toJSONString());
            sb.append(':');
            if (en.getValue() != null) {
                sb.append(en.getValue().toJSONObject().toJSONString());
                continue;
            }
            sb.append("null");
        }
        sb.append('}');
        return sb.toString();
    }

    public static String toJSONArrayString(Set<? extends Identifier> set) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (Identifier identifier : set) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(JSONSerializers.toJSONString(identifier));
        }
        sb.append(']');
        return sb.toString();
    }
}

