/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.impl;

import com.nimbusds.oauth2.sdk.id.Subject;
import net.jcip.annotations.Immutable;

@Immutable
public final class SubjectKey {
    private final int sessionNumber;
    private final Subject subject;
    private final String keyValue;

    public SubjectKey(Subject subject, int sessionNumber) {
        if (subject == null) {
            throw new IllegalArgumentException("The UID must not be null");
        }
        this.subject = subject;
        if (sessionNumber < 1) {
            throw new IllegalArgumentException("The session number must be equal or greater than 1");
        }
        this.sessionNumber = sessionNumber;
        this.keyValue = subject.getValue() + ":" + sessionNumber;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return this.keyValue;
    }

    public int hashCode() {
        return this.keyValue.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SubjectKey && this.toString().equals(object.toString());
    }

    public static SubjectKey parse(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        int sepPos = s.lastIndexOf(58);
        if (sepPos < 1) {
            return null;
        }
        try {
            Subject subject = new Subject(s.substring(0, sepPos));
            int num = Integer.parseInt(s.substring(sepPos + 1));
            return new SubjectKey(subject, num);
        }
        catch (Exception e) {
            return null;
        }
    }
}

