/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.impl;

import com.nimbusds.sessionstore.Configuration;
import com.nimbusds.sessionstore.SubjectSession;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class TimeResolver {
    private final Configuration config;

    public TimeResolver(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("The session store configuration must not be null");
        }
        this.config = config;
    }

    public long resolveMaxLifetimeMinutes(SubjectSession session) {
        long time = session.getMaxLifetime();
        if (time == 0L) {
            return this.config.maxLifetime;
        }
        return time;
    }

    public long resolveAuthLifetimeMinutes(SubjectSession session) {
        long time = session.getAuthLifetime();
        if (time == 0L) {
            return this.config.authLifetime;
        }
        return time;
    }

    public long resolveMaxIdleTimeMinutes(SubjectSession session) {
        long time = session.getMaxIdleTime();
        if (time == 0L) {
            return this.config.maxIdleTime;
        }
        return time;
    }
}

