/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.sessionstore.SessionQuotaExhaustionPolicy;
import com.nimbusds.sessionstore.impl.Loggers;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import net.jcip.annotations.Immutable;

@Immutable
public final class Configuration
implements LoggableConfiguration {
    public static final String PREFIX = "sessionStore.";
    public final int maxLifetime;
    public final int authLifetime;
    public final int maxIdleTime;
    public final int quotaPerSubject;
    public final SessionQuotaExhaustionPolicy onQuotaExhaustion;
    public final int purgeInterval;
    public final BearerAccessToken apiAccessToken;

    public Configuration(Properties props) throws ConfigurationException {
        PropertyRetriever pr = new PropertyRetriever(props);
        try {
            this.maxLifetime = pr.getInt("sessionStore.maxLifetime");
            if ((long)this.maxLifetime == 0L) {
                throw new PropertyParseException("The maximum lifetime must not be zero", "sessionStore.maxLifetime");
            }
            this.authLifetime = pr.getInt("sessionStore.authLifetime");
            if ((long)this.authLifetime == 0L) {
                throw new PropertyParseException("The authentication lifetime must not be zero", "sessionStore.authLifetime");
            }
            this.maxIdleTime = pr.getInt("sessionStore.maxIdleTime");
            if ((long)this.maxIdleTime == 0L) {
                throw new PropertyParseException("The maximum idle time must not be zero", "sessionStore.maxIdleTime");
            }
            this.quotaPerSubject = pr.getInt("sessionStore.quotaPerSubject");
            if (this.quotaPerSubject <= 0) {
                throw new PropertyParseException("The session quota must be greater than zero", "sessionStore.quotaPerSubject", Integer.toString(this.quotaPerSubject));
            }
            this.onQuotaExhaustion = (SessionQuotaExhaustionPolicy)pr.getEnum("sessionStore.onQuotaExhaustion", SessionQuotaExhaustionPolicy.class);
            this.purgeInterval = pr.getInt("sessionStore.purgeInterval");
            if (this.purgeInterval < 1) {
                throw new PropertyParseException("The session purge interval must be a positive integer", "sessionStore.purgeInterval", Integer.toString(this.purgeInterval));
            }
            String accessTokenValue = pr.getOptString("sessionStore.apiAccessToken", null);
            if (accessTokenValue != null && accessTokenValue.length() < 32) {
                throw new PropertyParseException("The access token must be at least 32 characters long", "sessionStore.master");
            }
            this.apiAccessToken = accessTokenValue != null ? new BearerAccessToken(accessTokenValue) : null;
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey());
        }
    }

    public void log() {
        if (this.maxLifetime > 0) {
            Loggers.MAIN_LOG.info("[SS0100] Max subject session lifetime: {} minutes", new Object[]{this.maxLifetime});
        } else {
            Loggers.MAIN_LOG.info("[SS0101] Max subject session lifetime: indefinite");
        }
        if (this.authLifetime > 0) {
            Loggers.MAIN_LOG.info("[SS0102] Max subject authentication lifetime: {} minutes", new Object[]{this.authLifetime});
        } else {
            Loggers.MAIN_LOG.info("[SS0103] Max subject authentication lifetime: indefinite");
        }
        if (this.maxIdleTime > 0) {
            Loggers.MAIN_LOG.info("[SS0104] Max idle subject session time: {} minutes", new Object[]{this.maxIdleTime});
        } else {
            Loggers.MAIN_LOG.info("[SS0105] Max idle subject session time: indefinite");
        }
        Loggers.MAIN_LOG.info("[SS0106] Session quota per subject: {}", new Object[]{this.quotaPerSubject});
        Loggers.MAIN_LOG.info("[SS0107] Policy on subject session quota exhaustion: {}", new Object[]{this.onQuotaExhaustion});
        Loggers.MAIN_LOG.info("[SS0108] Purge interval for expired subject sessions: {} minutes", new Object[]{this.purgeInterval});
        Loggers.MAIN_LOG.info("[SS0109] Access token defined (enables web API): {}", new Object[]{this.apiAccessToken != null});
    }
}

