/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.nimbusds.common.appendable.Appendable;
import com.nimbusds.common.id.SID;
import com.nimbusds.common.monitor.MonitorRegistries;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.sessionstore.AbstractSubjectSessionStore;
import com.nimbusds.sessionstore.Configuration;
import com.nimbusds.sessionstore.SessionQuotaException;
import com.nimbusds.sessionstore.SubjectAuthentication;
import com.nimbusds.sessionstore.SubjectSession;
import com.nimbusds.sessionstore.impl.Loggers;
import com.nimbusds.sessionstore.impl.NotificationDispatcher;
import com.nimbusds.sessionstore.impl.SessionExpirationTask;
import com.nimbusds.sessionstore.impl.SessionMeters;
import com.nimbusds.sessionstore.impl.SubjectKey;
import com.nimbusds.sessionstore.impl.TimeResolver;
import com.nimbusds.sessionstore.notifications.NotificationListeners;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;

@ThreadSafe
public class InfinispanSubjectSessionStore
extends AbstractSubjectSessionStore {
    public static final String SESSION_MAP_NAME = "sessionStore.sessionMap";
    public static final String SUBJECT_MAP_NAME = "sessionStore.subjectMap";
    private final Cache<SID, SubjectSession> sessionMap;
    private final Cache<SubjectKey, SID> subjectMap;
    private final NotificationDispatcher notificationDispatcher = new NotificationDispatcher();
    private final TimeResolver timeResolver = new TimeResolver(this.config);
    private Timer expirationTimer;
    private final SessionMeters meters = new SessionMeters();

    public InfinispanSubjectSessionStore(Configuration config, EmbeddedCacheManager cacheManager) {
        super(config);
        this.sessionMap = cacheManager.getCache(SESSION_MAP_NAME);
        this.subjectMap = cacheManager.getCache(SUBJECT_MAP_NAME);
        this.initSessionExpirationTask();
        this.registerGauges();
    }

    private void initSessionExpirationTask() {
        this.expirationTimer = new Timer("session-expiration-timer", true);
        SessionExpirationTask task = new SessionExpirationTask(this);
        int interval = this.config.purgeInterval * 60 * 1000;
        this.expirationTimer.schedule((TimerTask)task, interval, (long)interval);
        Loggers.MAIN_LOG.info("[SS0207] Scheduled task to remove expired subject sessions every {} minutes", new Object[]{this.config.purgeInterval});
    }

    private void registerGauges() {
        MonitorRegistries.register((String)"sessionStore.numSessions", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InfinispanSubjectSessionStore.this.sessionMap.size();
            }
        });
    }

    private void registerSubject(Subject subject, SID sid) throws SessionQuotaException {
        HashSet<SID> subjectSIDs = new HashSet<SID>();
        for (int n = 1; n <= this.config.quotaPerSubject; ++n) {
            SubjectKey testKey = new SubjectKey(subject, n);
            SID found = (SID)this.subjectMap.putIfAbsent((Object)testKey, (Object)sid);
            if (found == null) {
                Loggers.SESSION_LOG.debug("[SS0208] Registered subject {} at slot {} with SID {}", new Object[]{subject, n, sid});
                return;
            }
            subjectSIDs.add(found);
        }
        switch (this.config.onQuotaExhaustion) {
            case DENY_LOGIN: {
                throw new SessionQuotaException(subject, this.config.quotaPerSubject);
            }
            case CLOSE_OLD_SESSION: {
                final HashMap subjectSessions = new HashMap();
                this.get(subjectSIDs, new Appendable<Map.Entry<SID, SubjectSession>>(){

                    public void append(Map.Entry<SID, SubjectSession> element) {
                        subjectSessions.put(element.getKey(), element.getValue());
                    }
                });
                Map.Entry oldestSessionEntry = null;
                for (Map.Entry entry : subjectSessions.entrySet()) {
                    if (oldestSessionEntry == null) {
                        oldestSessionEntry = entry;
                        continue;
                    }
                    if (!((SubjectSession)entry.getValue()).getCreationTime().before(((SubjectSession)oldestSessionEntry.getValue()).getCreationTime())) continue;
                    oldestSessionEntry = entry;
                }
                if (oldestSessionEntry != null) {
                    SubjectSession removedSession = this.remove((SID)oldestSessionEntry.getKey());
                    Loggers.SESSION_LOG.debug("[SS0209] Found and closed old session with SID {} : {}", new Object[]{oldestSessionEntry.getKey(), removedSession != null});
                }
                this.registerSubject(subject, sid);
            }
        }
    }

    private boolean unregisterSubject(Subject subject, SID sid) {
        for (int n = 1; n <= this.config.quotaPerSubject; ++n) {
            SubjectKey testKey = new SubjectKey(subject, n);
            if (!this.subjectMap.remove((Object)testKey, (Object)sid)) continue;
            Loggers.SESSION_LOG.info("[SS0210] Removed session: subject={}, sid={}, slot={}", new Object[]{subject, sid, n});
            return true;
        }
        return false;
    }

    private void applyTimeDefaults(SubjectSession session) {
        if (session.getMaxLifetime() == 0L) {
            session.setMaxLifetime(this.timeResolver.resolveMaxLifetimeMinutes(session));
        }
        if (session.getAuthLifetime() == 0L) {
            session.setAuthLifetime(this.timeResolver.resolveAuthLifetimeMinutes(session));
        }
        if (session.getMaxIdleTime() == 0L) {
            session.setMaxIdleTime(this.timeResolver.resolveMaxIdleTimeMinutes(session));
        }
    }

    @Override
    public Map.Entry<SID, SubjectSession> add(SubjectSession session) throws SessionQuotaException {
        SID sid = new SID();
        this.registerSubject(session.getSubject(), sid);
        this.applyTimeDefaults(session);
        Loggers.SESSION_LOG.debug("[SS0200] Preparing to add session (with time defaults applied): {}", new Object[]{session.toJSONObject()});
        if (this.sessionMap.putIfAbsent((Object)sid, (Object)session) != null) {
            this.unregisterSubject(session.getSubject(), sid);
            throw new IllegalStateException("Couldn't add session to store: SID collision: " + sid);
        }
        Loggers.SESSION_LOG.info("[SS0201] Created new session: subject={}, sid={}", new Object[]{session.getSubject(), sid});
        if (Loggers.SESSION_LOG.isDebugEnabled()) {
            CacheEntry entry = this.sessionMap.getAdvancedCache().getCacheEntry((Object)sid);
            if (entry != null) {
                Loggers.SESSION_LOG.debug("[SS0202] Cache entry lifetime: {}", new Object[]{entry.getLifespan()});
                Loggers.SESSION_LOG.debug("[SS0203] Cache entry max idle: {}", new Object[]{entry.getMaxIdle()});
            } else {
                Loggers.SESSION_LOG.debug("[SS0204] No cache entry effectively added");
            }
        }
        this.meters.newSessions.mark();
        this.notificationDispatcher.dispatchSessionAddNotification(sid, session);
        return new ImmutablePair((Object)sid, (Object)session);
    }

    @Override
    public SubjectSession get(SID sid) {
        SubjectSession session = (SubjectSession)this.sessionMap.get((Object)sid);
        if (session == null) {
            return null;
        }
        Date now = new Date();
        if (session.hasExpired(now)) {
            this.remove(sid);
            return null;
        }
        session.setLastAccessTime(now);
        this.sessionMap.replaceAsync((Object)sid, (Object)session);
        this.meters.sessionRetrievals.mark();
        return session;
    }

    @Override
    public void get(Subject subject, Appendable<Map.Entry<SID, SubjectSession>> appendable) {
        for (int n = 1; n <= this.config.quotaPerSubject; ++n) {
            SubjectSession session;
            SubjectKey testKey = new SubjectKey(subject, n);
            SID sid = (SID)this.subjectMap.get((Object)testKey);
            if (sid == null || (session = this.get(sid)) == null) continue;
            appendable.append((Object)new ImmutablePair((Object)sid, (Object)session));
        }
    }

    @Override
    public void getAll(Appendable<Map.Entry<SID, SubjectSession>> appendable) {
        for (Map.Entry entry : this.sessionMap.entrySet()) {
            appendable.append((Object)entry);
        }
    }

    @Override
    public boolean hasSession(Subject subject) {
        for (int n = 1; n <= this.config.quotaPerSubject; ++n) {
            SubjectKey testKey = new SubjectKey(subject, n);
            SID sid = (SID)this.subjectMap.get((Object)testKey);
            if (sid == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSubjectAuthentication(SID sid, SubjectAuthentication subjectAuth) {
        SubjectSession session = (SubjectSession)this.sessionMap.get((Object)sid);
        if (session == null) {
            return false;
        }
        if (!session.getSubject().equals((Object)subjectAuth.getSubject())) {
            return false;
        }
        session.updateSubjectAuthentication(subjectAuth);
        session.updateLastAccessTime();
        this.sessionMap.replaceAsync((Object)sid, (Object)session);
        this.meters.sessionAuthUpdates.mark();
        return true;
    }

    @Override
    public boolean updateData(SID sid, JSONObject data) {
        SubjectSession session = (SubjectSession)this.sessionMap.get((Object)sid);
        if (session == null) {
            return false;
        }
        session.setData(data);
        session.updateLastAccessTime();
        this.sessionMap.replaceAsync((Object)sid, (Object)session);
        this.meters.sessionDataUpdates.mark();
        return true;
    }

    @Override
    public boolean updateClaims(SID sid, JSONObject claims) {
        SubjectSession session = (SubjectSession)this.sessionMap.get((Object)sid);
        if (session == null) {
            return false;
        }
        session.setClaims(claims);
        session.updateLastAccessTime();
        this.sessionMap.replaceAsync((Object)sid, (Object)session);
        this.meters.sessionDataUpdates.mark();
        return true;
    }

    @Override
    public SubjectSession remove(SID sid) {
        boolean forExpiration = false;
        return this.remove(sid, false);
    }

    private SubjectSession remove(SID sid, boolean forExpiration) {
        SubjectSession session = (SubjectSession)this.sessionMap.remove((Object)sid);
        if (session == null) {
            return null;
        }
        this.unregisterSubject(session.getSubject(), sid);
        if (forExpiration) {
            this.meters.sessionExpirations.mark();
        } else {
            this.meters.sessionClosures.mark();
        }
        this.notificationDispatcher.dispatchSessionRemoveNotification(sid, session);
        return session;
    }

    @Override
    public void remove(Subject subject, final Appendable<Map.Entry<SID, SubjectSession>> appendable) {
        this.get(subject, new Appendable<Map.Entry<SID, SubjectSession>>(){

            public void append(Map.Entry<SID, SubjectSession> entry) {
                if (InfinispanSubjectSessionStore.this.remove(entry.getKey()) != null) {
                    appendable.append(entry);
                }
            }
        });
    }

    @Override
    public void removeAll(Appendable<Map.Entry<SID, SubjectSession>> appendable) {
        for (SID sid : this.sessionMap.keySet()) {
            SubjectSession session = this.remove(sid);
            if (session == null) continue;
            appendable.append((Object)new ImmutablePair((Object)sid, (Object)session));
        }
    }

    @Override
    public void getSubjects(Appendable<Subject> appendable) {
        HashSet<Subject> outputSubjects = new HashSet<Subject>();
        for (SubjectKey key : this.subjectMap.keySet()) {
            Subject subject = key.getSubject();
            if (outputSubjects.contains(subject)) continue;
            appendable.append((Object)subject);
            outputSubjects.add(subject);
        }
    }

    @Override
    public int countSessions(Subject subject) {
        int sessionCount = 0;
        for (int n = 1; n <= this.config.quotaPerSubject; ++n) {
            SubjectKey testKey = new SubjectKey(subject, n);
            if (!this.subjectMap.containsKey((Object)testKey)) continue;
            ++sessionCount;
        }
        return sessionCount;
    }

    @Override
    public int countSessions() {
        return this.sessionMap.size();
    }

    public void purgeExpiredSessions() {
        Date now = new Date();
        Loggers.SESSION_LOG.debug("[SS0205] Purging expired subject sessions...");
        int removeCounter = 0;
        for (SID sid : this.sessionMap.keySet()) {
            SubjectSession session = (SubjectSession)this.sessionMap.get((Object)sid);
            if (session == null || !session.hasExpired(now)) continue;
            this.remove(sid);
            ++removeCounter;
        }
        if (removeCounter > 0) {
            Loggers.SESSION_LOG.info("[SS0206] Purged {} expired subject sessions", new Object[]{removeCounter});
        }
    }

    @Override
    public NotificationListeners getNotificationListeners() {
        return this.notificationDispatcher;
    }

    public void shutdown() {
        this.expirationTimer.cancel();
    }
}

