/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.nimbusds.common.id.SID;
import com.nimbusds.common.monitor.MonitorRegistries;
import com.nimbusds.sessionstore.SubjectSession;
import com.nimbusds.sessionstore.notifications.NotificationListeners;
import com.nimbusds.sessionstore.notifications.SessionAddedNotification;
import com.nimbusds.sessionstore.notifications.SessionAddedNotificationListener;
import com.nimbusds.sessionstore.notifications.SessionRemovedNotification;
import com.nimbusds.sessionstore.notifications.SessionRemovedNotificationListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class NotificationDispatcher
implements NotificationListeners {
    private final Set<SessionAddedNotificationListener> addListeners = new HashSet<SessionAddedNotificationListener>();
    private final Set<SessionRemovedNotificationListener> removeListeners = new HashSet<SessionRemovedNotificationListener>();
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(0, 4, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public NotificationDispatcher() {
        MonitorRegistries.register((String)"sessionStore.queuedNotifications", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return NotificationDispatcher.this.pool.getQueue().size();
            }
        });
    }

    public void dispatchSessionAddNotification(SID sid, SubjectSession session) {
        if (this.addListeners.isEmpty()) {
            return;
        }
        final SessionAddedNotification notification = new SessionAddedNotification(sid, session);
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                for (SessionAddedNotificationListener listener : NotificationDispatcher.this.addListeners) {
                    listener.notify(notification);
                }
            }
        });
    }

    public void dispatchSessionRemoveNotification(SID sid, SubjectSession session) {
        if (this.removeListeners.isEmpty()) {
            return;
        }
        final SessionRemovedNotification notification = new SessionRemovedNotification(sid, session);
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                for (SessionRemovedNotificationListener listener : NotificationDispatcher.this.removeListeners) {
                    listener.notify(notification);
                }
            }
        });
    }

    @Override
    public void add(SessionAddedNotificationListener listener) {
        this.addListeners.add(listener);
    }

    @Override
    public void remove(SessionAddedNotificationListener listener) {
        this.addListeners.remove(listener);
    }

    @Override
    public void add(SessionRemovedNotificationListener listener) {
        this.removeListeners.add(listener);
    }

    @Override
    public void remove(SessionRemovedNotificationListener listener) {
        this.removeListeners.remove(listener);
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

