/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.impl.ext;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.AMR;
import com.nimbusds.sessionstore.SubjectAuthentication;
import com.nimbusds.sessionstore.SubjectSession;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.minidev.json.JSONObject;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class SubjectSessionExternalizerV2
implements AdvancedExternalizer<SubjectSession> {
    public Set<Class<? extends SubjectSession>> getTypeClasses() {
        HashSet<Class<? extends SubjectSession>> types = new HashSet<Class<? extends SubjectSession>>();
        types.add(SubjectSession.class);
        return types;
    }

    public Integer getId() {
        return 10110;
    }

    public void writeObject(ObjectOutput output, SubjectSession subjectSession) throws IOException {
        SubjectAuthentication auth = subjectSession.getSubjectAuthentication();
        output.writeUTF(auth.getSubject().getValue());
        output.writeLong(auth.getTime().getTime());
        if (auth.getACR() != null) {
            output.writeBoolean(true);
            output.writeUTF(auth.getACR().getValue());
        } else {
            output.writeBoolean(false);
        }
        if (auth.getAMRList() != null) {
            output.writeBoolean(true);
            output.writeInt(auth.getAMRList().size());
            for (AMR amr : auth.getAMRList()) {
                output.writeUTF(amr.getValue());
            }
        } else {
            output.writeBoolean(false);
        }
        output.writeLong(subjectSession.getCreationTime().getTime());
        output.writeLong(subjectSession.getLastAccessTime().getTime());
        output.writeLong(subjectSession.getMaxLifetime());
        output.writeLong(subjectSession.getAuthLifetime());
        output.writeLong(subjectSession.getMaxIdleTime());
        if (subjectSession.getClaims() != null) {
            output.writeBoolean(true);
            output.writeUTF(subjectSession.getClaims().toJSONString());
        } else {
            output.writeBoolean(false);
        }
        if (subjectSession.getData() != null) {
            output.writeBoolean(true);
            output.writeUTF(subjectSession.getData().toJSONString());
        } else {
            output.writeBoolean(false);
        }
    }

    public SubjectSession readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Subject subject = new Subject(input.readUTF());
        Date authTime = new Date(input.readLong());
        ACR acr = null;
        boolean acrFollows = input.readBoolean();
        if (acrFollows) {
            acr = new ACR(input.readUTF());
        }
        ArrayList<AMR> amrList = null;
        boolean amrListFollows = input.readBoolean();
        if (amrListFollows) {
            int listSize = input.readInt();
            amrList = new ArrayList<AMR>(listSize);
            for (int i = 0; i < listSize; ++i) {
                amrList.add(new AMR(input.readUTF()));
            }
        }
        SubjectAuthentication auth = new SubjectAuthentication(subject, authTime, acr, amrList);
        Date created = new Date(input.readLong());
        Date lastAccess = new Date(input.readLong());
        long maxLifetime = input.readLong();
        long authLifetime = input.readLong();
        long maxIdleTime = input.readLong();
        JSONObject claims = null;
        boolean jsonClaimsFollow = input.readBoolean();
        if (jsonClaimsFollow) {
            try {
                claims = JSONObjectUtils.parse((String)input.readUTF());
            }
            catch (ParseException e) {
                throw new IOException("Invalid claims JSON object: " + e.getMessage(), e);
            }
        }
        JSONObject data = null;
        boolean jsonDataFollows = input.readBoolean();
        if (jsonDataFollows) {
            try {
                data = JSONObjectUtils.parse((String)input.readUTF());
            }
            catch (ParseException e) {
                throw new IOException("Invalid data JSON object: " + e.getMessage(), e);
            }
        }
        SubjectSession session = new SubjectSession(auth, created, maxLifetime, authLifetime, maxIdleTime, claims, data);
        session.setLastAccessTime(lastAccess);
        return session;
    }
}

