/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.rest;

import com.nimbusds.common.servlet.ResourceRetriever;
import com.nimbusds.sessionstore.Configuration;
import com.nimbusds.sessionstore.impl.InfinispanSubjectSessionStore;
import com.nimbusds.sessionstore.impl.Loggers;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.Logger;
import org.infinispan.manager.EmbeddedCacheManager;

public class Launcher
implements ServletContextListener {
    public static final String CONFIG_CTX_PARAMETER_NAME = "sessionStore.configurationFile";
    public static final String STORE_CTX_ATTRIBUTE_NAME = "com.nimbusds.sessionstore.SubjectSessionStore";
    private InfinispanSubjectSessionStore sessionStore;

    public static void logOverridingSystemProperties() {
        Properties sysProps = System.getProperties();
        StringBuilder sb = new StringBuilder();
        for (String key : sysProps.stringPropertyNames()) {
            if (!key.startsWith("sessionStore.")) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(key);
        }
        Loggers.MAIN_LOG.info("[SS0306] Overriding system properties: {}", new Object[]{sb});
    }

    public void contextInitialized(ServletContextEvent sce) {
        Configuration sessionStoreConfig;
        EmbeddedCacheManager cacheManager;
        ServletContext servletContext = sce.getServletContext();
        try {
            cacheManager = (EmbeddedCacheManager)servletContext.getAttribute("org.infinispan.manager.EmbeddedCacheManager");
            Loggers.MAIN_LOG.info("[SS0300] Infinispan cache manager status: {}", new Object[]{cacheManager.getStatus()});
        }
        catch (Exception e) {
            String msg = "[SS0301] Couldn't retrieve Infinispan cache manager from servlet context: " + e.getMessage();
            Loggers.MAIN_LOG.fatal(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        try {
            Properties props = ResourceRetriever.getProperties((ServletContext)servletContext, (String)CONFIG_CTX_PARAMETER_NAME, (Logger)Loggers.MAIN_LOG);
            Launcher.logOverridingSystemProperties();
            props.putAll((Map<?, ?>)System.getProperties());
            sessionStoreConfig = new Configuration(props);
            sessionStoreConfig.log();
        }
        catch (Exception e) {
            String msg = "[SS0302] Couldn't load subject session store configuration: " + e.getMessage();
            Loggers.MAIN_LOG.fatal(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        try {
            this.sessionStore = new InfinispanSubjectSessionStore(sessionStoreConfig, cacheManager);
        }
        catch (Exception e) {
            String msg = "[SS0303] Couldn't create subject session store: " + e.getMessage();
            Loggers.MAIN_LOG.fatal(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        Loggers.MAIN_LOG.info("[SS0304] Started subject session store");
        servletContext.setAttribute(STORE_CTX_ATTRIBUTE_NAME, (Object)this.sessionStore);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.sessionStore.shutdown();
        Loggers.MAIN_LOG.info("[SS0305] Shut down subject session store");
    }
}

