/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.rest;

import com.nimbusds.common.appendable.Appendable;
import com.nimbusds.common.appendable.JSONArrayWriter;
import com.nimbusds.common.id.SID;
import com.nimbusds.common.oauth2.BasicAccessTokenValidator;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.sessionstore.SessionQuotaException;
import com.nimbusds.sessionstore.SubjectAuthentication;
import com.nimbusds.sessionstore.SubjectSession;
import com.nimbusds.sessionstore.SubjectSessionStore;
import com.nimbusds.sessionstore.impl.JSONObjectWriter;
import com.nimbusds.sessionstore.impl.Loggers;
import com.nimbusds.sessionstore.rest.WebAPIErrorResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
@Path(value="/")
public class WebAPI
extends Application {
    private final BasicAccessTokenValidator accessTokenValidator;
    private final SubjectSessionStore sessionStore;

    public WebAPI(@Context ServletContext servletContext) {
        Object ctxObject = servletContext.getAttribute("com.nimbusds.sessionstore.SubjectSessionStore");
        if (!(ctxObject instanceof SubjectSessionStore)) {
            throw new RuntimeException("Couldn't load OpenID Connect subject session store: Missing servlet context attribute");
        }
        this.sessionStore = (SubjectSessionStore)ctxObject;
        this.accessTokenValidator = new BasicAccessTokenValidator(this.sessionStore.getConfiguration().apiAccessToken);
        Loggers.MAIN_LOG.info("[SS0400] Created new JAX-RS subject session store endpoint instance");
    }

    public Set<Object> getSingletons() {
        HashSet<Object> set = new HashSet<Object>();
        set.add((Object)this);
        Loggers.MAIN_LOG.debug("[SS0401] Registered the subject session store with the JAX-RS container");
        return set;
    }

    public SubjectSessionStore getSessionStore() {
        return this.sessionStore;
    }

    @GET
    @Produces(value={"text/plain"})
    public String printBannerPage() {
        return "Web service: OpenID Connect session store\nSoftware vendor: Connect2id Ltd., http://connect2id.com, (c) 2010 - 2015\n\nSupported RESTful resources:\n\t/sessions\n\t/sessions/subject-auth\n\t/sessions/data\n\t/sessions/count\n\t/subjects";
    }

    @Path(value="/sessions")
    @POST
    @Consumes(value={"application/json"})
    public Response add(@HeaderParam(value="Authorization") String authz, String sessionSpec) {
        Map.Entry<SID, SubjectSession> sessionEntry;
        SubjectSession session;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        try {
            session = SubjectSession.parse(sessionSpec);
        }
        catch (ParseException e) {
            return WebAPIErrorResponse.badRequest(e.getMessage());
        }
        try {
            sessionEntry = this.sessionStore.add(session);
        }
        catch (SessionQuotaException e) {
            return WebAPIErrorResponse.exhaustedSessionQuota(e);
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0402] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        return Response.status((Response.Status)Response.Status.CREATED).header("SID", (Object)sessionEntry.getKey().toString()).build();
    }

    @Path(value="/sessions")
    @GET
    @Produces(value={"application/json"})
    public Response get(@HeaderParam(value="Authorization") String authz, @HeaderParam(value="SID") String sid, final @QueryParam(value="subject") String subject) {
        this.accessTokenValidator.validateBearerAccessToken(authz);
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            SubjectSession session;
            try {
                session = this.sessionStore.get(new SID(sid));
            }
            catch (Exception e) {
                Loggers.MAIN_LOG.error("[SS0403] {}", new Object[]{e.getMessage(), e});
                return WebAPIErrorResponse.serverError();
            }
            if (session == null) {
                return WebAPIErrorResponse.invalidSID();
            }
            return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)session.toJSONObject().toJSONString()).build();
        }
        if (StringUtils.isNotBlank((CharSequence)subject)) {
            StreamingOutput streamer = new StreamingOutput(){

                public void write(OutputStream os) throws IOException, WebApplicationException {
                    JSONObjectWriter writer = new JSONObjectWriter(new BufferedWriter(new OutputStreamWriter(os)));
                    writer.writeStart();
                    try {
                        WebAPI.this.sessionStore.get(new Subject(subject), (Appendable<Map.Entry<SID, SubjectSession>>)writer);
                    }
                    catch (Exception e) {
                        Loggers.MAIN_LOG.error("[SS0404] {}", new Object[]{e.getMessage(), e});
                        throw new WebApplicationException(e.getMessage(), (Throwable)e);
                    }
                    writer.writeEnd();
                }
            };
            return Response.ok((Object)streamer).build();
        }
        StreamingOutput streamer = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                JSONObjectWriter writer = new JSONObjectWriter(new BufferedWriter(new OutputStreamWriter(os)));
                writer.writeStart();
                try {
                    WebAPI.this.sessionStore.getAll(writer);
                }
                catch (Exception e) {
                    Loggers.MAIN_LOG.error("[SS0406] {}", new Object[]{e.getMessage(), e});
                    throw new WebApplicationException(e.getMessage(), (Throwable)e);
                }
                writer.writeEnd();
            }
        };
        return Response.ok((Object)streamer).build();
    }

    @Path(value="/sessions")
    @DELETE
    @Produces(value={"application/json"})
    public Response remove(@HeaderParam(value="Authorization") String authz, @HeaderParam(value="SID") String sid, final @QueryParam(value="subject") String subject, @QueryParam(value="all") String all) {
        this.accessTokenValidator.validateBearerAccessToken(authz);
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            SubjectSession session;
            try {
                session = this.sessionStore.remove(new SID(sid));
            }
            catch (Exception e) {
                Loggers.MAIN_LOG.error("[SS0412] {}", new Object[]{e.getMessage(), e});
                return WebAPIErrorResponse.serverError();
            }
            if (session == null) {
                return WebAPIErrorResponse.invalidSID();
            }
            return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)session.toJSONObject().toJSONString()).build();
        }
        if (StringUtils.isNotBlank((CharSequence)subject)) {
            StreamingOutput streamer = new StreamingOutput(){

                public void write(OutputStream os) throws IOException, WebApplicationException {
                    JSONObjectWriter writer = new JSONObjectWriter(new BufferedWriter(new OutputStreamWriter(os)));
                    writer.writeStart();
                    try {
                        WebAPI.this.sessionStore.remove(new Subject(subject), writer);
                    }
                    catch (Exception e) {
                        Loggers.MAIN_LOG.error("[SS0415] {}", new Object[]{e.getMessage(), e});
                        throw new WebApplicationException(e.getMessage(), (Throwable)e);
                    }
                    writer.writeEnd();
                }
            };
            return Response.ok((Object)streamer).build();
        }
        if ("true".equalsIgnoreCase(all)) {
            StreamingOutput streamer = new StreamingOutput(){

                public void write(OutputStream os) throws IOException, WebApplicationException {
                    JSONObjectWriter writer = new JSONObjectWriter(new BufferedWriter(new OutputStreamWriter(os)));
                    writer.writeStart();
                    try {
                        WebAPI.this.sessionStore.removeAll(writer);
                    }
                    catch (Exception e) {
                        Loggers.MAIN_LOG.error("[SS0413] {}", new Object[]{e.getMessage(), e});
                        throw new WebApplicationException(e.getMessage(), (Throwable)e);
                    }
                    writer.writeEnd();
                }
            };
            return Response.ok((Object)streamer).build();
        }
        return WebAPIErrorResponse.badRequest("No session(s) specified");
    }

    @Path(value="/sessions/count")
    @GET
    @Produces(value={"text/plain"})
    public Response count(@HeaderParam(value="Authorization") String authz, @QueryParam(value="subject") String subject) {
        int count;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        try {
            count = StringUtils.isNotBlank((CharSequence)subject) ? this.sessionStore.countSessions(new Subject(subject)) : this.sessionStore.countSessions();
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0405] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").entity((Object)Integer.toString(count)).build();
    }

    @Path(value="/sessions/subject-auth")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateSubjectAuth(@HeaderParam(value="Authorization") String authz, @HeaderParam(value="SID") String sid, String authSpec) {
        boolean found;
        SubjectAuthentication subjectAuth;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        if (StringUtils.isBlank((CharSequence)sid)) {
            return WebAPIErrorResponse.badRequest("Missing SID header parameter");
        }
        try {
            subjectAuth = SubjectAuthentication.parse(authSpec);
        }
        catch (ParseException e) {
            return WebAPIErrorResponse.badRequest(e.getMessage());
        }
        try {
            found = this.sessionStore.updateSubjectAuthentication(new SID(sid), subjectAuth);
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0409] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        if (!found) {
            return WebAPIErrorResponse.invalidSID();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/sessions/claims")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateClaims(@HeaderParam(value="Authorization") String authz, @HeaderParam(value="SID") String sid, String claimsSpec) {
        boolean found;
        JSONObject jsonObject;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        if (StringUtils.isBlank((CharSequence)sid)) {
            return WebAPIErrorResponse.badRequest("Missing SID header parameter");
        }
        try {
            jsonObject = JSONObjectUtils.parse((String)claimsSpec);
        }
        catch (ParseException e) {
            return WebAPIErrorResponse.badRequest(e.getMessage());
        }
        try {
            found = this.sessionStore.updateClaims(new SID(sid), jsonObject);
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0414] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        if (!found) {
            return WebAPIErrorResponse.invalidSID();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/sessions/claims")
    @DELETE
    public Response deleteClaims(@HeaderParam(value="Authorization") String authz, @HeaderParam(value="SID") String sid) {
        boolean found;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        if (StringUtils.isBlank((CharSequence)sid)) {
            return WebAPIErrorResponse.badRequest("Missing SID header parameter");
        }
        try {
            found = this.sessionStore.updateClaims(new SID(sid), null);
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0416] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        if (!found) {
            return WebAPIErrorResponse.invalidSID();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/sessions/data")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateData(@HeaderParam(value="Authorization") String authz, @HeaderParam(value="SID") String sid, String dataSpec) {
        boolean found;
        JSONObject jsonObject;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        if (StringUtils.isBlank((CharSequence)sid)) {
            return WebAPIErrorResponse.badRequest("Missing SID header parameter");
        }
        try {
            jsonObject = JSONObjectUtils.parse((String)dataSpec);
        }
        catch (ParseException e) {
            return WebAPIErrorResponse.badRequest(e.getMessage());
        }
        try {
            found = this.sessionStore.updateData(new SID(sid), jsonObject);
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0410] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        if (!found) {
            return WebAPIErrorResponse.invalidSID();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/sessions/data")
    @DELETE
    public Response deleteData(@HeaderParam(value="Authorization") String authz, @HeaderParam(value="SID") String sid) {
        boolean found;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        if (StringUtils.isBlank((CharSequence)sid)) {
            return WebAPIErrorResponse.badRequest("Missing SID header parameter");
        }
        try {
            found = this.sessionStore.updateData(new SID(sid), null);
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0411] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        if (!found) {
            return WebAPIErrorResponse.invalidSID();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/subjects")
    @GET
    @Produces(value={"application/json"})
    public Response getSubjects(@HeaderParam(value="Authorization") String authz) {
        this.accessTokenValidator.validateBearerAccessToken(authz);
        StreamingOutput streamer = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                JSONArrayWriter writer = new JSONArrayWriter((Writer)new BufferedWriter(new OutputStreamWriter(os)));
                writer.writeStart();
                try {
                    WebAPI.this.sessionStore.getSubjects((Appendable<Subject>)writer);
                }
                catch (Exception e) {
                    Loggers.MAIN_LOG.error("[SS0407] {}", new Object[]{e.getMessage(), e});
                    throw new WebApplicationException(e.getMessage(), (Throwable)e);
                }
                writer.writeEnd();
            }
        };
        return Response.ok((Object)streamer).build();
    }

    @Path(value="/subjects/count")
    @GET
    @Produces(value={"text/plain"})
    public Response countSubjects(@HeaderParam(value="Authorization") String authz) {
        int count;
        this.accessTokenValidator.validateBearerAccessToken(authz);
        try {
            count = this.sessionStore.countSubjects();
        }
        catch (Exception e) {
            Loggers.MAIN_LOG.error("[SS0408] {}", new Object[]{e.getMessage(), e});
            return WebAPIErrorResponse.serverError();
        }
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").entity((Object)Integer.toString(count)).build();
    }
}

