/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.sessionstore.rest;

import com.nimbusds.sessionstore.SessionQuotaException;
import javax.ws.rs.core.Response;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class WebAPIErrorResponse {
    private static final String INVALID_SID;
    private static final String SERVER_ERROR;

    public static Response badRequest(String message) {
        JSONObject o = new JSONObject();
        o.put((Object)"error", (Object)"invalid_request");
        o.put((Object)"error_description", (Object)("Bad request: " + message));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)o.toJSONString()).build();
    }

    public static Response invalidSID() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").entity((Object)INVALID_SID).build();
    }

    public static Response exhaustedSessionQuota(SessionQuotaException e) {
        JSONObject o = new JSONObject();
        o.put((Object)"error", (Object)"exhausted_session_quota");
        o.put((Object)"error_description", (Object)("Over session quota: " + e.getMessage()));
        return Response.status((Response.Status)Response.Status.CONFLICT).type("application/json").entity((Object)o.toJSONString()).build();
    }

    public static Response serverError() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)SERVER_ERROR).build();
    }

    private WebAPIErrorResponse() {
    }

    static {
        JSONObject o = new JSONObject();
        o.put((Object)"error", (Object)"invalid_session_id");
        o.put((Object)"error_description", (Object)"Not found: Invalid SID or expired session");
        INVALID_SID = o.toJSONString();
        o = new JSONObject();
        o.put((Object)"error", (Object)"server_error");
        o.put((Object)"error_description", (Object)"Internal server error: Check the logs for details");
        SERVER_ERROR = o.toJSONString();
    }
}

