/*
 * Decompiled with CFR 0.152.
 */
package com.noenv.cronutils.impl;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.noenv.cronutils.CronScheduler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;

public class CronSchedulerImpl
implements CronScheduler,
Handler<Long> {
    private final Vertx vertx;
    private final ExecutionTime expression;
    private Handler<CronScheduler> handler;
    private long timerId;
    private ZonedDateTime executionTime;

    public CronSchedulerImpl(Vertx vertx, String cronExpression, CronType type) {
        this.vertx = vertx;
        CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)type);
        CronParser parser = new CronParser(definition);
        this.expression = ExecutionTime.forCron((Cron)parser.parse(cronExpression));
    }

    @Override
    public CronScheduler schedule(Handler<CronScheduler> handler) {
        Objects.requireNonNull(handler);
        if (this.handler != null) {
            throw new IllegalArgumentException("Scheduler is already registered.");
        }
        this.handler = handler;
        ZonedDateTime now = ZonedDateTime.now();
        this.expression.nextExecution(now).ifPresent(next -> {
            this.executionTime = next;
            long delay = this.getNextDelay(now);
            this.timerId = this.vertx.setTimer(delay, (Handler)this);
        });
        return this;
    }

    @Override
    public void cancel() {
        if (this.vertx.cancelTimer(this.timerId)) {
            this.handler = null;
        }
    }

    public final void handle(Long id) {
        if (this.handler == null) {
            return;
        }
        ZonedDateTime now = ZonedDateTime.now();
        this.expression.nextExecution(this.executionTime).ifPresent(next -> {
            this.executionTime = next;
            long delay = this.getNextDelay(now);
            this.timerId = this.vertx.setTimer(delay + 20L, (Handler)this);
        });
        this.handler.handle((Object)this);
    }

    private long getNextDelay(ZonedDateTime time) {
        Duration timeToNextExecution = Duration.between(time, this.executionTime);
        return Math.max(1L, timeToNextExecution.toMillis());
    }
}

