/*
 * Decompiled with CFR 0.152.
 */
package com.noenv.cronutils;

import com.cronutils.model.CronType;
import com.noenv.cronutils.CronScheduler;
import io.vertx.core.Vertx;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class CronSchedulerTest
extends VertxTestBase {
    @Test
    public void testCronExpression() throws IllegalArgumentException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(3);
        CronScheduler scheduler = CronScheduler.create((Vertx)this.vertx, (String)"0/1 * * * * ?", (CronType)CronType.QUARTZ).schedule(s -> latch.countDown());
        latch.await(5L, TimeUnit.SECONDS);
        scheduler.cancel();
        this.assertEquals(0L, latch.getCount());
    }

    @Test(expected=NullPointerException.class)
    public void testNoHandler() throws IllegalArgumentException {
        CronScheduler.create((Vertx)this.vertx, (String)"0 * * * * ?").schedule(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNoExpression() throws IllegalArgumentException {
        CronScheduler.create((Vertx)this.vertx, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFaultyExpression() throws IllegalArgumentException {
        CronScheduler.create((Vertx)this.vertx, (String)"broken expression");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleRegistration() throws IllegalArgumentException {
        CronScheduler.create((Vertx)this.vertx, (String)"0/1 * * * * ?").schedule(s -> System.out.println("register once")).schedule(s -> System.out.println("register twice")).cancel();
    }
}

