/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.generator;

import com.noleme.flow.actor.generator.GenerationException;
import com.noleme.flow.actor.generator.Generator;
import com.noleme.flow.interruption.InterruptionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderGenerator
implements Generator<String> {
    private final BufferedReader reader;
    private boolean hasNext;
    private static final Logger logger = LoggerFactory.getLogger(ReaderGenerator.class);

    public ReaderGenerator(InputStream stream) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
        this.hasNext = true;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public String generate() throws GenerationException {
        try {
            String line = this.reader.readLine();
            if (line == null) {
                this.hasNext = false;
                throw InterruptionException.interrupt();
            }
            return line;
        }
        catch (IOException e) {
            logger.error("An error occurred while attempting to read a line from the stream: " + e.getMessage(), (Throwable)e);
            throw new GenerationException(e.getMessage(), (Throwable)e);
        }
    }
}

