/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.generator;

import com.noleme.flow.actor.generator.GenerationException;
import com.noleme.flow.actor.generator.Generator;
import java.util.function.Predicate;

public class StatefulProducerGenerator<T>
implements Generator<T> {
    private final Producer<T> supplier;
    private final Predicate<T> condition;
    private T lastValue;

    public StatefulProducerGenerator(Producer<T> supplier, Predicate<T> condition) {
        this(supplier, condition, null);
    }

    public StatefulProducerGenerator(Producer<T> supplier, Predicate<T> condition, T initialState) {
        this.supplier = supplier;
        this.condition = condition;
        this.lastValue = initialState;
    }

    public boolean hasNext() {
        return this.condition.test(this.lastValue);
    }

    public T generate() throws GenerationException {
        this.lastValue = this.supplier.produce(this.lastValue);
        return this.lastValue;
    }

    public static interface Producer<T> {
        public T produce(T var1) throws GenerationException;
    }
}

