/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.loader.file;

import com.noleme.commons.stream.Streams;
import com.noleme.flow.actor.loader.Loader;
import com.noleme.flow.actor.loader.LoadingException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriteInputStream<I extends InputStream>
implements Loader<I> {
    private final String outputFile;
    private final boolean append;
    private static final Logger logger = LoggerFactory.getLogger(FileWriteInputStream.class);

    public FileWriteInputStream(String outputFile) {
        this(outputFile, false);
    }

    public FileWriteInputStream(String outputFile, boolean append) {
        this.outputFile = outputFile;
        this.append = append;
    }

    public void load(I is) throws LoadingException {
        try {
            logger.info("Loading contents into {} (mode: {})", (Object)this.outputFile, (Object)(this.append ? "append" : "create"));
            Streams.flow(is, (OutputStream)new FileOutputStream(this.outputFile, this.append));
        }
        catch (IOException e) {
            throw new LoadingException("An error occurred while attempting to offload file at " + this.outputFile + ".", (Throwable)e);
        }
    }
}

