/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.loader.file;

import com.fasterxml.jackson.databind.JsonNode;
import com.noleme.commons.stream.Streams;
import com.noleme.flow.actor.loader.Loader;
import com.noleme.flow.actor.loader.LoadingException;
import com.noleme.json.Json;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriteJson<J extends JsonNode>
implements Loader<J> {
    private final String outputFile;
    private final boolean append;
    private static final Logger logger = LoggerFactory.getLogger(FileWriteJson.class);

    public FileWriteJson(String outputFile) {
        this(outputFile, false);
    }

    public FileWriteJson(String outputFile, boolean append) {
        this.outputFile = outputFile;
        this.append = append;
    }

    public void load(J json) throws LoadingException {
        try {
            logger.info("Loading json into {} (mode: {})", (Object)this.outputFile, (Object)(this.append ? "append" : "create"));
            String string = Json.prettyPrint(json);
            Streams.flow((InputStream)new ByteArrayInputStream(string.getBytes()), (OutputStream)new FileOutputStream(this.outputFile, this.append));
        }
        catch (IOException e) {
            throw new LoadingException("An error occurred while attempting to offload file at " + this.outputFile + ".", (Throwable)e);
        }
    }
}

